# 🚀 Bait Alamer - cPanel Deployment Checklist

## 📦 Files to Upload

Upload ALL these files to your cPanel file manager:

### **Root Directory** (`public_html/Bait-alamer/`)
```
✅ index.php (password protected calculator)
✅ calculator.js
✅ styles.css
✅ print-styles.css (NEW - ensures clean print)
✅ logo.png
✅ announcements.json
✅ announcements.php
✅ Bait_Alamer_Pricing_QA_Calculator.xlsx (optional)
```

### **Customer Portal** (`public_html/Bait-alamer/customer/`)
```
✅ login.php
✅ customer.php
✅ logout.php
✅ users.php
✅ save_prices.php
✅ calculator_customer.js
✅ styles.css
✅ print-styles.css (NEW - ensures clean print)
✅ logo.png
✅ prices.json
✅ README.md (optional)
✅ SETUP_GUIDE.txt (optional)
```

---

## 🔧 File Permissions (Important!)

Set these permissions in cPanel File Manager:

```bash
Main Directory:
- index.php                → 644
- calculator.js            → 644
- styles.css               → 644
- print-styles.css         → 644
- announcements.json       → 666 (writable)
- announcements.php        → 644

Customer Directory:
- All .php files          → 644
- prices.json             → 666 (writable)
- customer/ folder        → 755
```

**Critical:** Make `prices.json` and `announcements.json` writable (666) so PHP can update them.

---

## ⚙️ After Upload Steps

### 1. **Test Main Calculator**
- Visit: `https://tuxedo.click/Bait-alamer/`
- Password: `bait2025`
- Login → Should see calculator
- Click "📢 Manage Announcements" → Should open management page
- Test Print/PDF → Should NOT show buttons

### 2. **Test Customer Portal**
- Visit: `https://tuxedo.click/Bait-alamer/customer/login.php`
- Login as manager: `manager` / `manager123`
- Should see: User bar, announcements (if any), save prices button
- Test Print/PDF → Should NOT show any UI elements

- Login as sales: `sales` / `sales123`
- Should see: Read-only prices
- Test Print/PDF → Should be clean

### 3. **Test Logout**
- Click Logout in main calculator → Should redirect to clean password page
- Click Logout in customer portal → Should redirect to login page
- Try logging in again → Should work without issues

---

## 🔒 Security - Change These Immediately!

### **Main Calculator Password** (`index.php` line 8)
```php
define('INTERNAL_PASSWORD', 'bait2025');  // ← CHANGE THIS!
```

### **Customer Portal Users** (`customer/users.php`)
```php
$users = [
    ['username' => 'manager', 'password' => 'manager123', 'role' => 'pricing_manager'],
    ['username' => 'sales', 'password' => 'sales123', 'role' => 'sales_consultant'],
];
// ↑ CHANGE ALL PASSWORDS!
```

---

## 🖨️ Print/PDF Clean Output

The system now includes **TWO** layers of print protection:

1. **`styles.css`** - Main print styles with `.no-print` class
2. **`print-styles.css`** - Extra layer with aggressive hiding

### **Elements Hidden in Print:**
- ❌ User info bar (username, role badge)
- ❌ Logout button
- ❌ Manage Announcements button
- ❌ Save Prices section
- ❌ Announcements section
- ❌ Language toggle
- ❌ All buttons and links in navigation

### **What Prints:**
- ✅ Header with logo
- ✅ Site Information fields
- ✅ Selected items table
- ✅ Summary and totals
- ✅ Clean, professional layout

---

## 🐛 Troubleshooting

### **Problem: Buttons still show in print**
**Solution:** Clear browser cache (Ctrl+Shift+Delete)

### **Problem: Cannot save prices**
**Solution:** Check file permissions on `prices.json` (should be 666)

### **Problem: Cannot save announcements**
**Solution:** Check file permissions on `announcements.json` (should be 666)

### **Problem: Logout doesn't work**
**Solution:** 
- Check that `index.php` line 22 has: `header('Location: index.php');`
- Check PHP sessions are enabled on server

### **Problem: 500 Internal Server Error**
**Solution:** Check file permissions (all .php should be 644, not 777)

---

## 📝 Default Credentials Reference

### Main Calculator:
- **Password:** `bait2025`

### Customer Portal:
| Username | Password | Role |
|----------|----------|------|
| manager | manager123 | Pricing Manager |
| sales | sales123 | Sales Consultant |
| admin | admin2025 | Pricing Manager |

---

## ✅ Final Verification Checklist

Before going live, verify:

- [ ] All files uploaded to cPanel
- [ ] File permissions set correctly
- [ ] `prices.json` is writable (666)
- [ ] `announcements.json` is writable (666)
- [ ] Main calculator loads with password
- [ ] Customer portal login works
- [ ] Logout works without URL glitches
- [ ] Print/PDF is clean (no buttons/UI)
- [ ] Both roles tested (manager & sales)
- [ ] Passwords changed from defaults
- [ ] SSL/HTTPS working (https://tuxedo.click)

---

## 🎉 You're Ready!

Once all items are checked, your system is production-ready!

**Support:** If issues persist, check browser console (F12) for JavaScript errors.

© 2025 Bait Alamer | Deployment Guide v1.0

