# 📤 Upload Instructions for cPanel

## ✅ Fixed Issues

1. ✅ Removed demo credentials from customer login page
2. ✅ Added URL routing with `.htaccess` files
3. ✅ Clean login pages for both systems
4. ✅ Protected sensitive files

---

## 📦 Files to Upload to cPanel

### **Main Directory** (`public_html/Bait-alamer/`)

Upload these files:

```
✅ index.html (redirects to index.php)
✅ index.php (password protected main calculator)
✅ calculator.js
✅ styles.css (updated with print rules)
✅ print-styles.css (NEW - dedicated print CSS)
✅ logo.png
✅ announcements.json
✅ announcements.php
✅ .htaccess (NEW - URL routing & security)
```

### **Customer Directory** (`public_html/Bait-alamer/customer/`)

Upload these files:

```
✅ login.php (UPDATED - removed demo credentials)
✅ customer.php (UPDATED - includes print CSS)
✅ logout.php
✅ users.php
✅ save_prices.php
✅ calculator_customer.js
✅ styles.css (updated)
✅ print-styles.css (NEW)
✅ logo.png
✅ prices.json
✅ .htaccess (NEW - customer portal security)
```

---

## 🔧 File Permissions (Critical!)

After upload, set these permissions in cPanel:

### Main Directory:
```
Files (.php, .js, .css, .html) → 644
announcements.json → 666 (writable)
.htaccess → 644
```

### Customer Directory:
```
All .php files → 644
prices.json → 666 (writable)
.htaccess → 644
customer/ folder → 755
```

---

## 🌐 URLs After Upload

### **Main Calculator:**
- Primary: `https://tuxedo.click/Bait-alamer/` → Shows password page
- Alternate: `https://tuxedo.click/Bait-alamer/index.php` → Shows password page
- Wrong URL: `https://tuxedo.click/Bait-alamer/login` → Redirects to index.php ✅

### **Customer Portal:**
- Login: `https://tuxedo.click/Bait-alamer/customer/` → Shows clean login
- Direct: `https://tuxedo.click/Bait-alamer/customer/login.php` → Shows clean login
- Protected: `https://tuxedo.click/Bait-alamer/customer/customer.php` → Redirects to login if not logged in ✅

---

## ✨ What Changed

### **1. Customer Login Page**
**Before:** Showed ugly demo credentials box  
**After:** Clean, professional login (no hints)

### **2. URL Routing**
**Before:** `/login` showed wrong page  
**After:** `/login` redirects to `index.php` (main calculator)

### **3. Security**
- ✅ Customer portal protected from direct access
- ✅ Sensitive files (users.php, prices.json) blocked
- ✅ Directory listing disabled
- ✅ Security headers enabled

### **4. Print/PDF**
- ✅ Double-layer print CSS
- ✅ All UI elements hidden
- ✅ Clean output for customers

---

## 🧪 Testing After Upload

### **Test 1: Main Calculator**
1. Visit: `https://tuxedo.click/Bait-alamer/`
2. Enter password: `bait2025`
3. Should see calculator with manage announcements button
4. Test print (Ctrl+P) → Should be clean, no buttons

### **Test 2: Customer Portal**
1. Visit: `https://tuxedo.click/Bait-alamer/customer/`
2. Should see clean login page (NO demo credentials)
3. Login as: `manager` / `manager123`
4. Should see calculator with editable prices
5. Test print (Ctrl+P) → Should be clean, no UI

### **Test 3: Direct Customer Access (Security)**
1. Visit: `https://tuxedo.click/Bait-alamer/customer/customer.php`
2. Without logging in first
3. Should redirect to login page ✅

### **Test 4: Logout**
1. Click logout in either system
2. Should redirect cleanly without URL parameters
3. Should be able to login again immediately

---

## 🔒 Change Passwords!

### **Main Calculator** (`index.php` line 8):
```php
define('INTERNAL_PASSWORD', 'bait2025');  // ← CHANGE THIS!
```

### **Customer Portal** (`customer/users.php`):
```php
$users = [
    ['username' => 'manager', 'password' => 'manager123', ...],  // ← CHANGE
    ['username' => 'sales', 'password' => 'sales123', ...],      // ← CHANGE
];
```

---

## ⚠️ Important Notes

1. **Clear browser cache** after upload (Ctrl+Shift+Delete)
2. **Test in incognito/private** window to see fresh version
3. **Check file permissions** - most critical step
4. **Enable SSL** - Use https:// not http://

---

## 🐛 If Something Breaks

### "500 Internal Server Error"
- Check `.htaccess` syntax
- Check file permissions (should be 644, not 777)
- Disable `.htaccess` temporarily to isolate issue

### "Customer page shows login with credentials"
- Make sure you uploaded the UPDATED `customer/login.php`
- Clear browser cache
- Check in incognito window

### "Print still shows buttons"
- Upload both `styles.css` AND `print-styles.css`
- Clear browser cache
- Try different browser

### "Logout doesn't work"
- Check PHP sessions enabled on server
- Upload updated `index.php` and `customer/logout.php`

---

## ✅ Upload Checklist

Before marking complete:

- [ ] All files uploaded to correct directories
- [ ] File permissions set (644 for files, 666 for JSON)
- [ ] `.htaccess` files uploaded
- [ ] Both print CSS files uploaded
- [ ] Updated customer/login.php (no demo box)
- [ ] Tested main calculator
- [ ] Tested customer portal
- [ ] Tested print/PDF output
- [ ] Changed default passwords
- [ ] Tested logout functionality

---

## 🎉 You're Done!

Once all items checked, your system is production-ready with:
- ✅ Clean, professional login pages
- ✅ Protected customer portal
- ✅ Clean print/PDF output
- ✅ Proper URL routing
- ✅ Security measures in place

© 2025 Bait Alamer | Upload Guide v2.0

