<?php
session_start();

// Check if user is authenticated for internal access
if (!isset($_SESSION['internal_auth']) || $_SESSION['internal_auth'] !== true) {
    header('Location: index.php');
    exit;
}

// Handle form submissions
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $announcementsFile = 'announcements.json';
    $announcements = [];
    
    if (file_exists($announcementsFile)) {
        $announcementsJson = file_get_contents($announcementsFile);
        $announcements = json_decode($announcementsJson, true) ?: [];
    }
    
    if (isset($_POST['action'])) {
        if ($_POST['action'] === 'add' && !empty($_POST['announcement_text'])) {
            // Add new announcement
            $newId = count($announcements) > 0 ? max(array_column($announcements, 'id')) + 1 : 1;
            $newAnnouncement = [
                'id' => $newId,
                'message' => trim($_POST['announcement_text']),
                'date' => date('Y-m-d H:i:s'),
                'active' => true
            ];
            array_unshift($announcements, $newAnnouncement);
            $message = 'Announcement added successfully!';
        } elseif ($_POST['action'] === 'delete' && isset($_POST['announcement_id'])) {
            // Delete announcement
            $announcements = array_filter($announcements, function($a) {
                return $a['id'] != $_POST['announcement_id'];
            });
            $announcements = array_values($announcements);
            $message = 'Announcement deleted successfully!';
        } elseif ($_POST['action'] === 'toggle' && isset($_POST['announcement_id'])) {
            // Toggle active status
            foreach ($announcements as &$announcement) {
                if ($announcement['id'] == $_POST['announcement_id']) {
                    $announcement['active'] = !$announcement['active'];
                    $message = 'Announcement status updated!';
                    break;
                }
            }
        }
        
        // Save back to file
        file_put_contents($announcementsFile, json_encode($announcements, JSON_PRETTY_PRINT));
    }
    
    // Redirect to prevent form resubmission
    header('Location: announcements.php?msg=' . urlencode($message));
    exit;
}

// Load announcements
$announcementsFile = 'announcements.json';
$announcements = [];
if (file_exists($announcementsFile)) {
    $announcementsJson = file_get_contents($announcementsFile);
    $announcements = json_decode($announcementsJson, true) ?: [];
}

// Get message from URL if exists
$displayMessage = isset($_GET['msg']) ? $_GET['msg'] : '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Announcements - Bait Alamer</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        .admin-container {
            max-width: 1000px;
            margin: 40px auto;
            padding: 20px;
        }
        .admin-header {
            background: linear-gradient(135deg, #2c3e50, #34495e);
            color: white;
            padding: 30px;
            border-radius: 10px;
            margin-bottom: 30px;
        }
        .admin-header h1 {
            margin: 0 0 10px 0;
        }
        .admin-header p {
            margin: 0;
            opacity: 0.9;
        }
        .back-link {
            display: inline-block;
            margin-bottom: 20px;
            color: #e67e22;
            text-decoration: none;
            font-weight: 600;
        }
        .back-link:hover {
            text-decoration: underline;
        }
        .add-announcement-box {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }
        .add-announcement-box h2 {
            margin: 0 0 20px 0;
            color: #333;
        }
        .announcement-textarea {
            width: 100%;
            padding: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
            font-family: inherit;
            box-sizing: border-box;
            resize: vertical;
            min-height: 100px;
        }
        .announcement-textarea:focus {
            outline: none;
            border-color: #e67e22;
        }
        .add-btn {
            background: #27ae60;
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 5px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            margin-top: 15px;
        }
        .add-btn:hover {
            background: #229954;
        }
        .announcements-list {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .announcements-list h2 {
            margin: 0 0 20px 0;
            color: #333;
        }
        .announcement-item {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 15px;
            position: relative;
        }
        .announcement-item.inactive {
            opacity: 0.5;
            background: #f9f9f9;
        }
        .announcement-status {
            position: absolute;
            top: 10px;
            right: 10px;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .announcement-status.active {
            background: #d4edda;
            color: #155724;
        }
        .announcement-status.inactive {
            background: #f8d7da;
            color: #721c24;
        }
        .announcement-message {
            font-size: 16px;
            color: #333;
            margin: 0 0 10px 0;
            padding-right: 100px;
        }
        .announcement-date {
            font-size: 13px;
            color: #666;
            margin: 0 0 15px 0;
        }
        .announcement-actions {
            display: flex;
            gap: 10px;
        }
        .action-btn {
            padding: 8px 16px;
            border: none;
            border-radius: 5px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
        }
        .toggle-btn {
            background: #3498db;
            color: white;
        }
        .toggle-btn:hover {
            background: #2980b9;
        }
        .delete-btn {
            background: #e74c3c;
            color: white;
        }
        .delete-btn:hover {
            background: #c0392b;
        }
        .success-message {
            background: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border: 1px solid #c3e6cb;
        }
        .no-announcements {
            text-align: center;
            padding: 40px;
            color: #999;
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <a href="Alnublaa" class="back-link">← Back to Calculator</a>
        
        <div class="admin-header">
            <h1>📢 Manage Announcements</h1>
            <p>Create announcements that will be displayed to Pricing Managers in the customer portal</p>
        </div>

        <?php if ($displayMessage): ?>
            <div class="success-message">
                ✅ <?php echo htmlspecialchars($displayMessage); ?>
            </div>
        <?php endif; ?>

        <!-- Add New Announcement -->
        <div class="add-announcement-box">
            <h2>➕ Add New Announcement</h2>
            <form method="POST" action="">
                <input type="hidden" name="action" value="add">
                <textarea name="announcement_text" class="announcement-textarea" placeholder="Enter your announcement message here..." required></textarea>
                <button type="submit" class="add-btn">Add Announcement</button>
            </form>
        </div>

        <!-- Existing Announcements -->
        <div class="announcements-list">
            <h2>📋 Current Announcements</h2>
            
            <?php if (empty($announcements)): ?>
                <div class="no-announcements">
                    <p>No announcements yet. Add your first announcement above!</p>
                </div>
            <?php else: ?>
                <?php foreach ($announcements as $announcement): ?>
                    <div class="announcement-item <?php echo $announcement['active'] ? '' : 'inactive'; ?>">
                        <span class="announcement-status <?php echo $announcement['active'] ? 'active' : 'inactive'; ?>">
                            <?php echo $announcement['active'] ? 'Active' : 'Inactive'; ?>
                        </span>
                        
                        <p class="announcement-message"><?php echo nl2br(htmlspecialchars($announcement['message'])); ?></p>
                        <p class="announcement-date">📅 <?php echo htmlspecialchars($announcement['date']); ?></p>
                        
                        <div class="announcement-actions">
                            <form method="POST" action="" style="display: inline;">
                                <input type="hidden" name="action" value="toggle">
                                <input type="hidden" name="announcement_id" value="<?php echo $announcement['id']; ?>">
                                <button type="submit" class="action-btn toggle-btn">
                                    <?php echo $announcement['active'] ? '⏸️ Deactivate' : '▶️ Activate'; ?>
                                </button>
                            </form>
                            
                            <form method="POST" action="" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this announcement?');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="announcement_id" value="<?php echo $announcement['id']; ?>">
                                <button type="submit" class="action-btn delete-btn">🗑️ Delete</button>
                            </form>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>

