# ⚡ Quick Test Guide - Fix Verification

## 🎯 What Was Fixed

1. ✅ Added detailed console logging
2. ✅ Fixed BASE GRAND TOTAL display logic
3. ✅ Added error handling for email sending
4. ✅ Created debug tools

---

## 🧪 Test Now - Step by Step

### Test 1: Check Email System (2 minutes)

**URL:** Open this in your browser:
```
http://your-domain/Bait-alamer/customer/test_email.php
```

**Expected Result:**
- Page shows tests with ✅ checkmarks
- Check email `m.oday@pazogrp.com`
- Should receive 2 test emails within 2-5 minutes

**If emails don't arrive:**
- Check spam folder
- Check PHP mail configuration
- See TROUBLESHOOTING.md

---

### Test 2: Debug Page Test (3 minutes)

**Steps:**

1. **Login First:**
   - Go to: `http://your-domain/Bait-alamer/customer/login.php`
   - Username: `manager`
   - Password: `manager123`

2. **Open Debug Page:**
   ```
   http://your-domain/Bait-alamer/customer/debug_test.php
   ```

3. **Run Tests:**
   - Click **"🔍 Test JS Variables"**
     - Should see: `IS_PRICING_MANAGER: true`
     - Should see: `BASE_PRICE_MAP keys: 57`
   
   - Click **"📧 Test Email Send"**
     - Watch console output (black box)
     - Should see: `✅ Email sent successfully!`
     - Check `m.oday@pazogrp.com` inbox

**Expected Console Output:**
```
[14:30:45] === Testing JavaScript Variables ===
[14:30:45] USER_ROLE: pricing_manager
[14:30:45] IS_PRICING_MANAGER: true
[14:30:45] BASE_PRICE_MAP keys: 57
[14:30:45] === Testing Email Send ===
[14:30:46] 🌐 Sending POST request...
[14:30:47] Response Status: 200 OK
[14:30:47] ✅ Email sent successfully!
```

---

### Test 3: BASE GRAND TOTAL Display (3 minutes)

**As Pricing Manager:**

1. **Open Calculator:**
   ```
   http://your-domain/Bait-alamer/customer/customer.php
   ```

2. **Press F12** to open browser console

3. **Look for initialization messages:**
   ```
   ✅ Bait Alamer Customer Portal Calculator initialized
   👤 User Role: pricing_manager
   🔒 Pricing Manager: true
   💰 Base Prices Loaded: 57
   ```

4. **Fill Required Fields:**
   - Customer Name: `Test Customer`
   - Site Location: `Test Site`

5. **Select Any Item:**
   - Check checkbox for "Gypsum board flat KSA" (first item)
   - Enter Length: `10`
   - Enter Width: `5`

6. **Click "📊 Calculate Total"**

7. **Watch Console For:**
   ```
   🔍 Checking BASE GRAND TOTAL display:
     isPricingManager: true
     baseGrandTotal: 185000
     grandTotal: 190000
   ✅ Pricing Manager - Showing BASE GRAND TOTAL
   ✅ BASE GRAND TOTAL element created
   ```

8. **Look on Page:**
   - You should see **TWO** total lines:
   
   ```
   ┌────────────────────────────────┐
   │ GRAND TOTAL:                   │
   │ 1,900,000 IQD                  │  ← Orange background
   └────────────────────────────────┘
   
   ┌────────────────────────────────┐
   │ BASE GRAND TOTAL:              │
   │ 1,850,000 IQD                  │  ← Darker orange background
   └────────────────────────────────┘
   ```

**If you don't see BASE GRAND TOTAL:**
- Check console for errors (red text)
- Try hard refresh: `Ctrl+F5`
- Check if `IS_PRICING_MANAGER: true` in console
- See TROUBLESHOOTING.md

---

### Test 4: Email from Calculator (5 minutes)

**Continue from Test 3:**

1. **With items still selected and totals calculated**

2. **Click "🖨️ Print / Export PDF"**

3. **Watch Browser Console (F12):**
   ```
   📧 Starting email send process...
   User Role: pricing_manager
   📋 Order Number: 20251211-143045-782
   📦 Order Data: {orderNumber: "...", customerName: "..."}
   📊 Items count: 1
   💰 Selling Grand Total: 1900000
   💰 Base Grand Total: 1850000
   🌐 Sending POST request to send_order_email.php...
   📡 Response status: 200 OK
   ✅ Order email sent successfully!
   📧 Order Number: 20251211-143045-782
   📬 Email sent: true
   ```

4. **Print dialog should appear** with customer PDF (no base prices)

5. **Check Email: m.oday@pazogrp.com**
   - Should receive email within 2-5 minutes
   - Subject: "Bait Alamer Order #20251211-143045-782 – Internal Summary"
   - Contains HTML attachment
   - Open attachment in browser - should show base prices

6. **Check Orders Log:**
   ```
   customer/orders.log
   ```
   Last line should show: `Email: Sent`

---

### Test 5: Sales Consultant (3 minutes)

1. **Logout** (click Logout button)

2. **Login as Sales:**
   - Username: `zaidoun`
   - Password: `sales123`

3. **Press F12** (console)

4. **Look for:**
   ```
   👤 User Role: sales_consultant
   🔒 Pricing Manager: false
   👤 Sales Consultant mode: Prices are read-only
   ```

5. **Verify:**
   - Prices are grayed out (not editable)
   - No "Save Prices" button
   - No base prices visible anywhere

6. **Create Order** (same as Test 3):
   - Fill customer info
   - Select items
   - Click "Calculate Total"

7. **Check Console:**
   ```
   🔍 Checking BASE GRAND TOTAL display:
     isPricingManager: false
   👤 Sales Consultant - Hiding BASE GRAND TOTAL
   ```

8. **Verify on Page:**
   - Only **ONE** total line visible: **GRAND TOTAL**
   - No BASE GRAND TOTAL line

9. **Click "Print / Export PDF"**

10. **Watch Console** - should still send email:
    ```
    📧 Starting email send process...
    User Role: sales_consultant
    ✅ Order email sent successfully!
    ```

11. **Check Email: m.oday@pazogrp.com**
    - Should receive internal PDF with base prices
    - (Even though sales consultant doesn't see them!)

---

## 🎯 Success Criteria

### ✅ All Tests Pass If:

- [x] Test emails arrive at m.oday@pazogrp.com
- [x] Debug page shows correct role and variables
- [x] Pricing Manager sees BASE GRAND TOTAL (two lines)
- [x] Sales Consultant sees only GRAND TOTAL (one line)
- [x] Both roles send emails successfully
- [x] Console shows no red errors
- [x] Email contains HTML attachment with base prices
- [x] orders.log shows "Email: Sent"
- [x] Customer PDF (on screen) never shows base prices

---

## ❌ If Any Test Fails

### Console Shows Errors?
→ Copy error messages
→ Check TROUBLESHOOTING.md
→ Look for specific error in troubleshooting guide

### Email Not Arriving?
→ Run `test_email.php` first
→ Check spam folder
→ Check PHP mail configuration
→ See "Email Not Sending" in TROUBLESHOOTING.md

### BASE GRAND TOTAL Not Showing?
→ Hard refresh (Ctrl+F5)
→ Check console: `IS_PRICING_MANAGER` should be `true`
→ See "BASE GRAND TOTAL Not Showing" in TROUBLESHOOTING.md

### Still Stuck?
→ Open `debug_test.php`
→ Run all tests
→ Screenshot console output
→ Check TROUBLESHOOTING.md

---

## 📱 Quick Reference URLs

After deploying to your server, replace `your-domain` with actual domain:

```
Login:
http://your-domain/Bait-alamer/customer/login.php

Calculator:
http://your-domain/Bait-alamer/customer/customer.php

Test Email:
http://your-domain/Bait-alamer/customer/test_email.php

Debug Tool:
http://your-domain/Bait-alamer/customer/debug_test.php
```

---

## 🔧 Browser Console Shortcuts

- **Open Console:**
  - Windows: `F12` or `Ctrl+Shift+I`
  - Mac: `Cmd+Option+I`

- **Hard Refresh:**
  - Windows: `Ctrl+F5` or `Ctrl+Shift+R`
  - Mac: `Cmd+Shift+R`

- **Clear Console:**
  - Click 🚫 icon in console
  - Or type: `console.clear()`

---

## 📋 User Credentials (Test Accounts)

### Pricing Managers:
```
Username: manager
Password: manager123

Username: admin  
Password: admin2025
```

### Sales Consultants:
```
Username: zaidoun
Password: sales123

Username: sales
Password: sales123
```

**⚠️ Important:** Change these passwords before going live!

---

## 🎉 Expected Final Result

### For Pricing Managers:
- ✅ Can edit prices
- ✅ Sees base prices as labels
- ✅ Sees BASE GRAND TOTAL in summary
- ✅ Email sent with internal PDF

### For Sales Consultants:
- ✅ Prices are read-only
- ✅ No base prices visible
- ✅ Only GRAND TOTAL visible
- ✅ Email still sent with internal PDF (but they don't know!)

### For Management (m.oday@pazogrp.com):
- ✅ Receives email for EVERY quote
- ✅ Email has full cost breakdown
- ✅ Shows profit per item
- ✅ Shows total profit and margin

### For Customers:
- ✅ Only see selling prices
- ✅ Never see base prices
- ✅ Clean professional PDF

---

**Duration:** All 5 tests should take ~15 minutes total

**Next Step:** After all tests pass, update passwords and go live!

---

**Created:** December 11, 2025  
**Version:** 2.0 - Debug & Fix Edition

