# Bait Alamer Customer Portal

## 📋 Overview

This is the customer/partner portal for Bait Alamer Pricing Calculator with authentication and role-based pricing management.

## 🗂️ File Structure

```
customer/
├── login.php              - Login page with authentication
├── customer.php           - Main calculator (role-based pricing)
├── save_prices.php        - API endpoint for saving prices (pricing managers only)
├── logout.php             - Session cleanup and logout
├── users.php              - User credentials and authentication functions
├── prices.json            - Price database (JSON file)
├── calculator_customer.js - Calculator logic with dynamic pricing
├── styles.css             - Same styling as main calculator
├── logo.png               - Company logo
└── README.md              - This file
```

## 👥 User Roles

### 1. Pricing Manager
- **Can view** unit prices
- **Can edit** unit prices
- **Can save** updated prices to `prices.json`
- Access to "Save Prices" button

### 2. Sales Consultant
- **Can view** unit prices (read-only)
- **Cannot edit** prices
- Can use calculator to generate quotes

## 🔐 Default Credentials

**Important: Change these passwords in `users.php` before deploying!**

| Username | Password    | Role              |
|----------|-------------|-------------------|
| manager  | manager123  | pricing_manager   |
| sales    | sales123    | sales_consultant  |
| admin    | admin2025   | pricing_manager   |

## 🚀 Setup Instructions

### 1. Server Requirements
- PHP 7.0 or higher
- Web server (Apache, Nginx, etc.)
- Session support enabled

### 2. Installation
1. Upload the entire `customer/` folder to your web server
2. Ensure the web server has write permissions for:
   - `prices.json`
   - Directory (for creating `price_updates.log`)

### 3. File Permissions (Linux/Unix)
```bash
chmod 666 customer/prices.json
chmod 775 customer/
```

### 4. Security Recommendations
- **Change default passwords** in `users.php`
- Consider implementing password hashing:
  ```php
  password_hash('your_password', PASSWORD_DEFAULT);
  password_verify($input, $hashed);
  ```
- Add HTTPS/SSL certificate for production
- Set up proper .htaccess rules
- Consider moving `users.php` outside web root

## 🔧 Usage

### For Pricing Managers:
1. Login with pricing manager credentials
2. Edit unit prices directly in the calculator
3. Click "Save Prices" button when done
4. Changes are saved to `prices.json`
5. All updates are logged to `price_updates.log`

### For Sales Consultants:
1. Login with sales consultant credentials
2. View current unit prices (read-only)
3. Use calculator to generate quotes
4. Print/Export PDF for customers

## 📝 Customization

### Adding New Users
Edit `users.php` and add to the `$users` array:
```php
[
    'username' => 'newuser',
    'password' => 'password123',  // Change this!
    'role' => 'sales_consultant'  // or 'pricing_manager'
]
```

### Changing Prices
**Pricing Managers:**
- Login and edit prices directly in the interface

**Manually:**
- Edit `prices.json` (make sure JSON is valid)

## 🔍 Troubleshooting

### Problem: Cannot save prices
**Solution:** Check file permissions on `prices.json`

### Problem: Session not persisting
**Solution:** Ensure PHP session support is enabled and `session_start()` works

### Problem: Prices not updating
**Solution:** Check browser console for errors, verify `save_prices.php` is accessible

### Problem: Login loop
**Solution:** Check PHP error logs, ensure cookies are enabled

## 📊 Features

✅ Session-based authentication (no database)  
✅ Role-based access control  
✅ Dynamic pricing from JSON file  
✅ Real-time price updates for managers  
✅ Read-only prices for consultants  
✅ All calculator features preserved  
✅ Same professional UI/UX  
✅ Print/Export PDF functionality  
✅ Price update logging  

## 🔒 Security Notes

- No database required (PHP sessions + JSON)
- Passwords stored in plain text by default (consider hashing for production)
- HTTPS recommended for production use
- Session timeout configured by PHP settings
- Price updates are logged with username and timestamp

## 📞 Support

For issues or questions, contact your system administrator.

---

© 2025 Bait Alamer | Customer Portal v1.0

