# 🚀 START HERE - Bait Alamer Email System

## ⚡ Quick Start (3 Steps)

### Step 1: Test Email System (2 minutes)
Open this URL in your browser:
```
http://your-domain/Bait-alamer/customer/test_email.php
```
✅ Should see green checkmarks  
✅ Check `m.oday@pazogrp.com` inbox  

---

### Step 2: Test Calculator (3 minutes)
1. Login at: `http://your-domain/Bait-alamer/customer/login.php`
   - Username: `manager`
   - Password: `manager123`

2. Press **F12** (open browser console)

3. Select any item, enter quantities

4. Click **"Calculate Total"**
   - Should see **2 lines**: GRAND TOTAL + BASE GRAND TOTAL

5. Click **"Print / Export PDF"**
   - Watch console for: `✅ Order email sent successfully!`
   - Check email inbox

---

### Step 3: Check Results
- [ ] Browser console shows no errors
- [ ] BASE GRAND TOTAL appears for manager
- [ ] Email received at `m.oday@pazogrp.com`
- [ ] Email has HTML attachment with base prices

---

## 📚 Full Documentation

**For Testing:**
→ Read `QUICK_TEST_GUIDE.md` (15 min of detailed tests)

**For Troubleshooting:**
→ Read `TROUBLESHOOTING.md` (if anything doesn't work)

**For Understanding:**
→ Read `EMAIL_SYSTEM_README.md` (system overview)

**For Technical Details:**
→ Read `FIXES_APPLIED.md` (what was changed)

---

## 🎯 What Should Work Now

### ✅ Pricing Managers:
- See BASE GRAND TOTAL (two total lines)
- Can edit selling prices
- Email sent automatically when printing

### ✅ Sales Consultants:
- Only see GRAND TOTAL (one line)
- Read-only prices
- Email still sent (they don't see base prices)

### ✅ Both Roles:
- Print button sends email to `m.oday@pazogrp.com`
- Customer PDF on screen (no base prices)
- Internal PDF in email (with base prices & profit)

---

## 🆘 Something Not Working?

1. **Open Browser Console** (Press F12)
2. **Look for red error messages**
3. **Check** `TROUBLESHOOTING.md` for your specific issue
4. **Run** `debug_test.php` for interactive testing

---

## 🔧 Debug Tools

| Tool | URL | Purpose |
|------|-----|---------|
| Test Email | `customer/test_email.php` | Test if emails work |
| Debug Page | `customer/debug_test.php` | Interactive debugger |
| Calculator | `customer/customer.php` | Main calculator |
| Login | `customer/login.php` | User login |

---

## 👥 Test Accounts

**Pricing Managers:**
- `manager` / `manager123`
- `admin` / `admin2025`

**Sales Consultants:**
- `zaidoun` / `sales123`
- `sales` / `sales123`

⚠️ **Change passwords before going live!**

---

## ✅ Success Looks Like This

**In Browser Console:**
```
✅ Bait Alamer Customer Portal Calculator initialized
👤 User Role: pricing_manager
🔒 Pricing Manager: true
💰 Base Prices Loaded: 57
💵 Selling Prices Loaded: 57
📧 Email will be sent to: m.oday@pazogrp.com
```

**On Calculator Page:**
```
┌─────────────────────────┐
│ GRAND TOTAL:            │
│ 1,900,000 IQD          │
└─────────────────────────┘

┌─────────────────────────┐
│ BASE GRAND TOTAL:       │  ← Only for managers
│ 1,850,000 IQD          │
└─────────────────────────┘
```

**When Printing:**
```
📧 Starting email send process...
📋 Order Number: 20251211-143045-782
✅ Order email sent successfully!
```

**In Email (m.oday@pazogrp.com):**
```
Subject: Bait Alamer Order #... – Internal Summary
Attachment: internal_cost_....html
Opens in browser → Shows base prices & profit
```

---

## 🎉 That's It!

**If all 3 steps above work:**  
✅ System is ready!  
✅ Deploy to production  
✅ Update passwords  
✅ Train users  

**If something doesn't work:**  
❌ Check browser console  
❌ Read TROUBLESHOOTING.md  
❌ Run debug_test.php  
❌ Ask for help with specific error messages  

---

**Next Step:** Run the 3 quick tests above!

**Time Needed:** 5-10 minutes

**Good Luck!** 🚀

