<?php
session_start();
require_once 'users.php';

// Check if user is logged in and is a pricing manager
if (!isLoggedIn() || !hasRole('pricing_manager')) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

// Get POST data
$data = json_decode(file_get_contents('php://input'), true);

if (!$data || !isset($data['username']) || !isset($data['newPassword'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit;
}

$username = $data['username'];
$newPassword = $data['newPassword'];
$isSelfChange = isset($data['isSelfChange']) && $data['isSelfChange'] === true;
$currentUser = $_SESSION['username'];

// If it's a self-password change, verify old password
if ($isSelfChange) {
    if ($username !== $currentUser) {
        http_response_code(403);
        echo json_encode(['success' => false, 'message' => 'You can only change your own password']);
        exit;
    }
    
    if (!isset($data['oldPassword'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Current password is required']);
        exit;
    }
    
    $oldPassword = $data['oldPassword'];
    
    // Verify old password
    $allUsers = getAllUsers();
    $userFound = false;
    foreach ($allUsers as $user) {
        if ($user['username'] === $username && $user['password'] === $oldPassword) {
            $userFound = true;
            break;
        }
    }
    
    if (!$userFound) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Current password is incorrect']);
        exit;
    }
}

// Validate password (minimum 6 characters)
if (strlen($newPassword) < 6) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Password must be at least 6 characters long']);
    exit;
}

// Update password
$success = updateUserPassword($username, $newPassword);

if ($success) {
    // Log the password change
    $logEntry = date('Y-m-d H:i:s') . " | Password changed for user: {$username} | Changed by: {$currentUser}" . ($isSelfChange ? " (self-change)" : "") . "\n";
    file_put_contents('password_changes.log', $logEntry, FILE_APPEND);
    
    echo json_encode([
        'success' => true,
        'message' => 'Password updated successfully'
    ]);
} else {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Failed to update password'
    ]);
}
?>
