<?php
/**
 * Email Debug Script - Production Test
 * Use this to diagnose email issues on production server
 */

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🔍 Email System Diagnostic</h1>";
echo "<hr>";

// Step 1: Check PHPMailer
echo "<h2>Step 1: PHPMailer Library</h2>";
if (file_exists('PHPMailer/src/PHPMailer.php')) {
    echo "<p style='color:green;'>✅ PHPMailer files found</p>";
    
    require 'PHPMailer/src/Exception.php';
    require 'PHPMailer/src/PHPMailer.php';
    require 'PHPMailer/src/SMTP.php';
    echo "<p style='color:green;'>✅ PHPMailer classes loaded successfully</p>";
} else {
    echo "<p style='color:red;'>❌ PHPMailer files NOT found at PHPMailer/src/</p>";
    die();
}

echo "<hr>";

// Step 2: Check email config
echo "<h2>Step 2: Email Configuration</h2>";
if (file_exists('email_config.php')) {
    echo "<p style='color:green;'>✅ email_config.php found</p>";
    $emailConfig = require 'email_config.php';
    echo "<p>SMTP Host: <strong>{$emailConfig['smtp_host']}</strong></p>";
    echo "<p>SMTP Port: <strong>{$emailConfig['smtp_port']}</strong></p>";
    echo "<p>From: <strong>{$emailConfig['from_email']}</strong></p>";
    echo "<p>To: <strong>{$emailConfig['to_email']}</strong></p>";
} else {
    echo "<p style='color:red;'>❌ email_config.php NOT found</p>";
    die();
}

echo "<hr>";

// Step 3: Check OpenSSL
echo "<h2>Step 3: PHP OpenSSL Extension</h2>";
if (extension_loaded('openssl')) {
    echo "<p style='color:green;'>✅ OpenSSL is ENABLED</p>";
} else {
    echo "<p style='color:red;'>❌ OpenSSL is DISABLED</p>";
    echo "<p><strong>Fix:</strong> Contact your hosting provider to enable OpenSSL extension</p>";
}

echo "<hr>";

// Step 4: Test SMTP Connection
echo "<h2>Step 4: SMTP Connection Test</h2>";
$mail = new PHPMailer(true);

try {
    // Enable verbose debug output
    $mail->SMTPDebug = 2;
    $mail->Debugoutput = function($str, $level) {
        echo "<div style='background:#f0f0f0; padding:5px; margin:2px; font-family:monospace; font-size:11px;'>" . htmlspecialchars($str) . "</div>";
    };
    
    // Server settings
    $mail->isSMTP();
    $mail->Host       = $emailConfig['smtp_host'];
    $mail->SMTPAuth   = $emailConfig['smtp_auth'];
    $mail->Username   = $emailConfig['smtp_username'];
    $mail->Password   = $emailConfig['smtp_password'];
    $mail->SMTPSecure = ($emailConfig['smtp_encryption'] === 'ssl') ? PHPMailer::ENCRYPTION_SMTPS : PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port       = $emailConfig['smtp_port'];
    $mail->CharSet    = 'UTF-8';
    
    // Recipients
    $mail->setFrom($emailConfig['from_email'], $emailConfig['from_name']);
    $mail->addAddress($emailConfig['to_email'], $emailConfig['to_name']);
    
    // Content
    $mail->isHTML(false);
    $mail->Subject = 'Bait Alamer - Test Email from Production';
    $mail->Body    = "This is a test email from the production server.\n\n";
    $mail->Body   .= "Server: " . $_SERVER['SERVER_NAME'] . "\n";
    $mail->Body   .= "Time: " . date('Y-m-d H:i:s') . "\n";
    $mail->Body   .= "PHP Version: " . PHP_VERSION . "\n\n";
    $mail->Body   .= "If you receive this, the email system is working!\n";
    
    // Send
    echo "<h3>📤 Sending Email...</h3>";
    $result = $mail->send();
    
    echo "<div style='background:#d4edda; padding:20px; margin:20px 0; border-left:5px solid #28a745;'>";
    echo "<h2 style='color:#155724; margin:0;'>✅ SUCCESS!</h2>";
    echo "<p style='color:#155724;'>Email sent successfully to <strong>{$emailConfig['to_email']}</strong></p>";
    echo "<p style='color:#155724;'>Please check your inbox (and spam folder)</p>";
    echo "</div>";
    
} catch (Exception $e) {
    echo "<div style='background:#f8d7da; padding:20px; margin:20px 0; border-left:5px solid #dc3545;'>";
    echo "<h2 style='color:#721c24; margin:0;'>❌ ERROR</h2>";
    echo "<p style='color:#721c24;'><strong>Message:</strong> {$mail->ErrorInfo}</p>";
    echo "<p style='color:#721c24;'><strong>Exception:</strong> " . $e->getMessage() . "</p>";
    echo "</div>";
    
    echo "<h3>🔧 Troubleshooting Steps:</h3>";
    echo "<ol>";
    echo "<li>Verify SMTP credentials are correct in email_config.php</li>";
    echo "<li>Check if port {$emailConfig['smtp_port']} is blocked by your hosting provider</li>";
    echo "<li>Try changing port to 587 and encryption to 'tls'</li>";
    echo "<li>Contact your hosting provider to enable SMTP on port {$emailConfig['smtp_port']}</li>";
    echo "<li>Check if the email address '{$emailConfig['smtp_username']}' is valid</li>";
    echo "</ol>";
}

echo "<hr>";
echo "<p><a href='customer.php'>← Back to Calculator</a></p>";
?>

