<?php
session_start();
require_once 'users.php';
require_once 'pricing_functions.php';

// التحقق من حالة قفل النظام
if (isSystemLocked()) {
    header('Location: maintenance.php');
    exit;
}

// If already logged in, redirect to customer page
if (isLoggedIn()) {
    header('Location: customer.php');
    exit;
}

$error = '';

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    $user = authenticateUser($username, $password);
    
    if ($user) {
        // Set session variables
        $_SESSION['username'] = $user['username'];
        $_SESSION['role'] = $user['role'];
        
        // Redirect to customer page
        header('Location: customer.php');
        exit;
    } else {
        $error = 'Invalid username or password';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Bait Alamer Customer Portal</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        html {
            scroll-behavior: smooth;
        }
        
        body {
            background: linear-gradient(135deg, #1a252f 0%, #2c3e50 50%, #1a252f 100%);
            background-attachment: fixed;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
            overflow-x: hidden;
        }
        
        /* Decorative background elements */
        body::before {
            content: '🏠';
            position: fixed;
            top: 10%;
            left: 5%;
            font-size: 150px;
            opacity: 0.03;
            pointer-events: none;
            animation: float1 6s ease-in-out infinite;
        }
        
        body::after {
            content: '🎨';
            position: fixed;
            bottom: 10%;
            right: 5%;
            font-size: 120px;
            opacity: 0.03;
            pointer-events: none;
            animation: float2 7s ease-in-out infinite;
        }
        
        @keyframes float1 {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(5deg); }
        }
        
        @keyframes float2 {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(20px) rotate(-5deg); }
        }
        
        @keyframes slideInScale {
            from {
                opacity: 0;
                transform: translateY(30px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }
        
        @keyframes shimmer {
            0%, 100% { opacity: 0.8; }
            50% { opacity: 1; }
        }
        
        @keyframes logoFloat {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-8px); }
        }
        
        .login-container {
            max-width: 450px;
            width: 100%;
            padding: 50px 45px;
            background: white;
            border-radius: 16px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.3), 0 0 30px rgba(243, 156, 18, 0.1);
            animation: slideInScale 0.8s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            position: relative;
            overflow: hidden;
        }
        
        .login-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #f39c12, #e67e22, #f39c12);
            background-size: 200% 100%;
            animation: shimmer 3s ease-in-out infinite;
        }
        
        .login-container::after {
            content: '✨';
            position: absolute;
            right: 20px;
            top: 20px;
            font-size: 40px;
            opacity: 0.1;
            pointer-events: none;
            animation: float1 4s ease-in-out infinite;
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 35px;
            position: relative;
            z-index: 1;
        }
        
        .login-header img {
            max-width: 180px;
            margin-bottom: 25px;
            filter: drop-shadow(0 4px 12px rgba(0, 0, 0, 0.1));
            animation: logoFloat 3s ease-in-out infinite;
            transition: all 0.4s ease;
        }
        
        .login-header img:hover {
            transform: scale(1.05) translateY(-5px);
            filter: drop-shadow(0 8px 20px rgba(243, 156, 18, 0.3));
        }
        
        .login-header h1 {
            font-size: 28px;
            color: #2c3e50;
            margin-bottom: 10px;
            font-weight: 700;
            letter-spacing: 0.5px;
            animation: slideInScale 0.8s ease-out 0.2s backwards;
        }
        
        .login-header p {
            color: #7f8c8d;
            font-size: 15px;
            font-weight: 500;
            animation: slideInScale 0.8s ease-out 0.3s backwards;
        }
        
        .form-group {
            margin-bottom: 25px;
            animation: slideInScale 0.6s ease-out backwards;
        }
        
        .form-group:nth-child(1) { animation-delay: 0.4s; }
        .form-group:nth-child(2) { animation-delay: 0.5s; }
        
        .form-group label {
            display: block;
            margin-bottom: 10px;
            font-weight: 700;
            color: #2c3e50;
            font-size: 14px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .form-group input {
            width: 100%;
            padding: 15px 18px;
            border: 2px solid #e0e6ed;
            border-radius: 10px;
            font-size: 15px;
            box-sizing: border-box;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            background: #f8f9fa;
            font-weight: 500;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #f39c12;
            background: white;
            box-shadow: 0 0 0 4px rgba(243, 156, 18, 0.1), 0 4px 15px rgba(243, 156, 18, 0.15);
            transform: translateY(-2px);
        }
        
        .form-group input::placeholder {
            color: #bdc3c7;
        }
        
        .login-btn {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #f39c12, #e67e22);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            text-transform: uppercase;
            letter-spacing: 1.5px;
            box-shadow: 0 4px 15px rgba(243, 156, 18, 0.3);
            position: relative;
            overflow: hidden;
            animation: slideInScale 0.6s ease-out 0.6s backwards;
        }
        
        .login-btn::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            transform: translate(-50%, -50%);
            transition: width 0.6s ease, height 0.6s ease;
        }
        
        .login-btn:hover::before {
            width: 400px;
            height: 400px;
        }
        
        .login-btn:hover {
            transform: translateY(-3px) scale(1.02);
            box-shadow: 0 8px 25px rgba(243, 156, 18, 0.5);
            background: linear-gradient(135deg, #e67e22, #d35400);
        }
        
        .login-btn:active {
            transform: translateY(-1px) scale(0.98);
            transition: all 0.1s ease;
        }
        
        .error-message {
            background: linear-gradient(135deg, #fee, #fdd);
            color: #c33;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            text-align: center;
            border-left: 4px solid #c33;
            font-weight: 600;
            animation: shake 0.5s ease-in-out, slideInScale 0.4s ease-out;
            box-shadow: 0 4px 15px rgba(204, 51, 51, 0.2);
        }
        
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-10px); }
            75% { transform: translateX(10px); }
        }
        
        /* Decorative elements in login form */
        form {
            position: relative;
        }
        
        form::before {
            content: '🔐';
            position: absolute;
            left: -15px;
            top: -15px;
            font-size: 35px;
            opacity: 0.1;
            pointer-events: none;
        }
        
        /* Responsive design */
        @media (max-width: 480px) {
            .login-container {
                padding: 35px 25px;
            }
            
            .login-header h1 {
                font-size: 24px;
            }
            
            .login-header img {
                max-width: 140px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <img src="logo.png" alt="Bait Alamer Logo">
            <h1>Customer Portal</h1>
            <p>Pricing Calculator System</p>
        </div>
        
        <?php if ($error): ?>
            <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" required autofocus>
            </div>
            
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>
            
            <button type="submit" class="login-btn">Login</button>
        </form>
    </div>
</body>
</html>

