<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>صيانة النظام - Bait Alamer</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #1a252f 0%, #2c3e50 50%, #1a252f 100%);
            background-attachment: fixed;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            color: #333;
        }
        
        .maintenance-container {
            background: white;
            border-radius: 20px;
            padding: 60px 50px;
            max-width: 600px;
            width: 100%;
            text-align: center;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            animation: fadeIn 0.6s ease-out;
        }
        
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .maintenance-icon {
            font-size: 120px;
            margin-bottom: 30px;
            animation: rotate 3s linear infinite;
        }
        
        @keyframes rotate {
            0%, 100% { transform: rotate(0deg); }
            25% { transform: rotate(-10deg); }
            75% { transform: rotate(10deg); }
        }
        
        h1 {
            font-size: 36px;
            color: #2c3e50;
            margin-bottom: 20px;
            font-weight: 700;
        }
        
        p {
            font-size: 18px;
            color: #7f8c8d;
            line-height: 1.8;
            margin-bottom: 15px;
        }
        
        .info-box {
            background: #ecf0f1;
            border-right: 4px solid #e67e22;
            padding: 20px;
            border-radius: 10px;
            margin-top: 30px;
            text-align: right;
        }
        
        .info-box p {
            color: #34495e;
            font-size: 16px;
            margin: 5px 0;
        }
        
        .logo {
            max-width: 200px;
            margin: 0 auto 30px;
            display: block;
        }
        
        @media (max-width: 600px) {
            .maintenance-container {
                padding: 40px 30px;
            }
            
            h1 {
                font-size: 28px;
            }
            
            .maintenance-icon {
                font-size: 80px;
            }
        }
    </style>
</head>
<body>
    <div class="maintenance-container">
        <img src="logo.png" alt="Bait Alamer Logo" class="logo" onerror="this.style.display='none'">
        
        <div class="maintenance-icon">🔧</div>
        
        <h1>النظام قيد الصيانة</h1>
        
        <p>نعتذر عن الإزعاج، النظام حالياً قيد الصيانة.</p>
        
        <p>سيتم إعادة فتح النظام قريباً.</p>
        
        <div class="info-box">
            <p><strong>بيت العامر</strong></p>
            <p>نظام حاسبة التسعير</p>
            <p style="font-size: 14px; color: #95a5a6; margin-top: 10px;">
                إذا كنت تعتقد أن هذا خطأ، يرجى الاتصال بالدعم الفني
            </p>
        </div>
    </div>
</body>
</html>
