<?php


define('SYSTEM_STATUS_FILE', __DIR__ . '/.pricing_status.json');


function isSystemLocked() {
    $statusFile = SYSTEM_STATUS_FILE;
    
    if (!file_exists($statusFile)) {
        return true;
    }
    
    $json = file_get_contents($statusFile);
    $status = json_decode($json, true);
    
    if (!is_array($status) || !isset($status['locked'])) {
        return true;
    }
    
    return $status['locked'] === true;
}


function lockSystem($lockedBy = 'system_admin') {
    $statusFile = SYSTEM_STATUS_FILE;
    
    $status = [
        'locked' => true,
        'locked_at' => date('Y-m-d H:i:s'),
        'unlocked_at' => null
    ];
    
    $json = json_encode($status, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    
    if (file_put_contents($statusFile, $json) !== false) {
        return true;
    }
    
    return false;
}


function unlockSystem($unlockedBy = 'system_admin') {
    $statusFile = SYSTEM_STATUS_FILE;
    
    $status = [
        'locked' => false,
        'locked_at' => null,
        'unlocked_at' => date('Y-m-d H:i:s')
    ];
    
    $json = json_encode($status, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    
    if (file_put_contents($statusFile, $json) !== false) {
        return true;
    }
    
    return false;
}


function getSystemStatus() {
    $statusFile = SYSTEM_STATUS_FILE;
    
    if (!file_exists($statusFile)) {
        return [
            'locked' => true,
            'locked_at' => null,
            'unlocked_at' => null
        ];
    }
    
    $json = file_get_contents($statusFile);
    $status = json_decode($json, true);
    
    if (!is_array($status)) {
        return [
            'locked' => true,
            'locked_at' => null,
            'unlocked_at' => null
        ];
    }
    
    return $status;
}
?>
