<?php
/**
 * ملف فحص شامل للنظام
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html>";
echo "<html lang='ar' dir='rtl'>";
echo "<head><meta charset='UTF-8'><title>فحص النظام</title>";
echo "<style>
    body { font-family: Arial; padding: 20px; background: #f5f5f5; }
    .box { background: white; padding: 20px; margin: 10px 0; border-radius: 8px; border: 2px solid #ddd; }
    .success { border-color: #3c3; background: #efe; }
    .error { border-color: #c33; background: #fee; }
    .warning { border-color: #fc3; background: #ffc; }
    h1 { color: #2c3e50; }
    h2 { color: #34495e; margin-top: 20px; }
    code { background: #f0f0f0; padding: 2px 6px; border-radius: 3px; }
    ul { line-height: 2; }
</style>";
echo "</head><body>";
echo "<h1>🔍 فحص شامل للنظام</h1>";

// 1. فحص PHP
echo "<div class='box success'>";
echo "<h2>1. إعدادات PHP</h2>";
echo "<p>✅ PHP Version: " . phpversion() . "</p>";
echo "<p>✅ Document Root: " . __DIR__ . "</p>";
echo "</div>";

// 2. فحص الملفات
echo "<div class='box'>";
echo "<h2>2. فحص الملفات</h2>";
$files = [
    'pricing_functions.php' => __DIR__ . '/customer/pricing_functions.php',
    '.pricing_status.json' => __DIR__ . '/customer/.pricing_status.json',
    'pricing_control.php' => __DIR__ . '/customer/pricing_control.php',
    'maintenance.php' => __DIR__ . '/customer/maintenance.php',
    'login.php' => __DIR__ . '/customer/login.php',
    'customer.php' => __DIR__ . '/customer/customer.php',
    'index.php' => __DIR__ . '/index.php'
];

$allExist = true;
foreach ($files as $name => $path) {
    if (file_exists($path)) {
        $writable = is_writable($path) ? ' (قابل للكتابة)' : ' (للقراءة فقط)';
        echo "<p>✅ <code>$name</code> موجود$writable</p>";
    } else {
        echo "<p>❌ <code>$name</code> غير موجود</p>";
        $allExist = false;
    }
}
echo "</div>";

// 3. فحص نظام القفل
echo "<div class='box'>";
echo "<h2>3. فحص نظام القفل</h2>";
if (file_exists(__DIR__ . '/customer/pricing_functions.php')) {
    try {
        require_once __DIR__ . '/customer/pricing_functions.php';
        echo "<p>✅ تم تحميل pricing_functions.php بنجاح</p>";
        
        $isLocked = isSystemLocked();
        echo "<p>الحالة: <strong>" . ($isLocked ? '🔒 مقفل' : '✅ مفتوح') . "</strong></p>";
        
        $status = getSystemStatus();
        if ($status) {
            echo "<p>تفاصيل الحالة:</p>";
            echo "<ul>";
            echo "<li>مقفل: " . ($status['locked'] ? 'نعم' : 'لا') . "</li>";
            if ($status['locked_at']) {
                echo "<li>تم القفل في: " . htmlspecialchars($status['locked_at']) . "</li>";
            }
            if ($status['unlocked_at']) {
                echo "<li>تم الفتح في: " . htmlspecialchars($status['unlocked_at']) . "</li>";
            }
            echo "</ul>";
        }
    } catch (Exception $e) {
        echo "<p class='error'>❌ خطأ: " . htmlspecialchars($e->getMessage()) . "</p>";
    }
} else {
    echo "<p class='error'>❌ ملف pricing_functions.php غير موجود</p>";
}
echo "</div>";

// 4. اختبار المسارات
echo "<div class='box'>";
echo "<h2>4. اختبار المسارات</h2>";
$testPaths = [
    'index.php -> customer/pricing_functions.php' => file_exists(__DIR__ . '/customer/pricing_functions.php'),
    'login.php -> pricing_functions.php' => file_exists(__DIR__ . '/customer/pricing_functions.php'),
    'customer.php -> pricing_functions.php' => file_exists(__DIR__ . '/customer/pricing_functions.php'),
];

foreach ($testPaths as $test => $result) {
    if ($result) {
        echo "<p>✅ $test</p>";
    } else {
        echo "<p class='error'>❌ $test</p>";
    }
}
echo "</div>";

// 5. روابط الاختبار
echo "<div class='box warning'>";
echo "<h2>5. روابط الاختبار</h2>";
$baseUrl = 'http://localhost:8000';
echo "<ul>";
echo "<li><a href='$baseUrl/test_server.php' target='_blank'>صفحة اختبار الخادم</a></li>";
echo "<li><a href='$baseUrl/customer/test_system_lock.php' target='_blank'>اختبار نظام القفل</a></li>";
echo "<li><a href='$baseUrl/customer/login.php' target='_blank'>صفحة تسجيل الدخول</a></li>";
echo "<li><a href='$baseUrl/index.php' target='_blank'>النظام الرئيسي</a></li>";
echo "<li><a href='$baseUrl/customer/maintenance.php' target='_blank'>صفحة الصيانة</a></li>";
$token = 'bait_alamer_lock_2025_xyz789';
echo "<li><a href='$baseUrl/customer/pricing_control.php?token=$token' target='_blank'>لوحة التحكم (المستخدم المخفي)</a></li>";
echo "</ul>";
echo "</div>";

// 6. معلومات إضافية
echo "<div class='box'>";
echo "<h2>6. معلومات إضافية</h2>";
echo "<p><strong>بيانات المستخدم المخفي:</strong></p>";
echo "<ul>";
echo "<li>اسم المستخدم: <code>##sysadmin##</code></li>";
echo "<li>كلمة المرور: <code>LockMaster2025!</code></li>";
echo "</ul>";
echo "<p><strong>Token:</strong> <code>bait_alamer_lock_2025_xyz789</code></p>";
echo "</div>";

echo "</body></html>";
?>
