<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Simple Email Test</h1>";
echo "<hr>";

// Test 1: Check if files exist
echo "<h2>Test 1: File Check</h2>";
$files = [
    'email_config.php',
    'PHPMailer/src/Exception.php',
    'PHPMailer/src/PHPMailer.php',
    'PHPMailer/src/SMTP.php'
];

$allFilesExist = true;
foreach ($files as $file) {
    if (file_exists($file)) {
        echo "<p style='color:green;'>✅ {$file}</p>";
    } else {
        echo "<p style='color:red;'>❌ {$file} NOT FOUND</p>";
        $allFilesExist = false;
    }
}

if (!$allFilesExist) {
    die("<p><strong>ERROR:</strong> Missing required files. Please upload all files.</p>");
}

echo "<hr>";

// Test 2: Load PHPMailer
echo "<h2>Test 2: Load PHPMailer</h2>";
try {
    require 'PHPMailer/src/Exception.php';
    require 'PHPMailer/src/PHPMailer.php';
    require 'PHPMailer/src/SMTP.php';
    
    echo "<p style='color:green;'>✅ PHPMailer loaded successfully</p>";
} catch (Exception $e) {
    die("<p style='color:red;'>❌ Failed to load PHPMailer: " . $e->getMessage() . "</p>");
}

echo "<hr>";

// Test 3: Load config
echo "<h2>Test 3: Email Configuration</h2>";
$emailConfig = require 'email_config.php';
echo "<p>Host: {$emailConfig['smtp_host']}</p>";
echo "<p>Port: {$emailConfig['smtp_port']}</p>";
echo "<p>User: {$emailConfig['smtp_username']}</p>";
echo "<p>Encryption: {$emailConfig['smtp_encryption']}</p>";

echo "<hr>";

// Test 4: Send email
echo "<h2>Test 4: Send Test Email</h2>";
echo "<p>Attempting to send email...</p>";

$mail = new PHPMailer(true);

try {
    // Server settings
    $mail->SMTPDebug = 0; // No debug output
    $mail->isSMTP();
    $mail->Host       = $emailConfig['smtp_host'];
    $mail->SMTPAuth   = true;
    $mail->Username   = $emailConfig['smtp_username'];
    $mail->Password   = $emailConfig['smtp_password'];
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // SSL
    $mail->Port       = $emailConfig['smtp_port'];
    $mail->CharSet    = 'UTF-8';
    
    // Recipients
    $mail->setFrom($emailConfig['from_email'], $emailConfig['from_name']);
    $mail->addAddress($emailConfig['to_email']);
    
    // Content
    $mail->Subject = 'Test from Bait Alamer - ' . date('Y-m-d H:i:s');
    $mail->Body    = 'This is a test email from the Bait Alamer system.';
    
    $mail->send();
    
    echo "<div style='background:#d4edda; padding:20px; margin:20px 0; border:2px solid #28a745;'>";
    echo "<h2 style='color:#155724;'>✅ EMAIL SENT SUCCESSFULLY!</h2>";
    echo "<p style='color:#155724;'>Check inbox: <strong>{$emailConfig['to_email']}</strong></p>";
    echo "</div>";
    
} catch (Exception $e) {
    echo "<div style='background:#f8d7da; padding:20px; margin:20px 0; border:2px solid #dc3545;'>";
    echo "<h2 style='color:#721c24;'>❌ EMAIL FAILED</h2>";
    echo "<p style='color:#721c24;'><strong>Error:</strong> {$mail->ErrorInfo}</p>";
    echo "<p style='color:#721c24;'><strong>Exception:</strong> " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
    
    echo "<h3>Possible Solutions:</h3>";
    echo "<ul>";
    echo "<li>Check SMTP username and password in email_config.php</li>";
    echo "<li>Verify the email account '{$emailConfig['smtp_username']}' exists and is active</li>";
    echo "<li>Try port 587 with TLS instead of 465 with SSL</li>";
    echo "<li>Contact hosting support to verify SMTP is allowed</li>";
    echo "</ul>";
}

echo "<hr>";
echo "<p><a href='customer.php'>Back to Calculator</a></p>";
?>

