<?php
echo "<h1>SMTP Connection Test - Both Ports</h1>";

$host = 'mail.pazogrp.com';
$tests = [
    ['port' => 465, 'protocol' => 'ssl', 'name' => 'SSL on Port 465'],
    ['port' => 587, 'protocol' => 'tls', 'name' => 'TLS on Port 587 (STARTTLS)'],
    ['port' => 25, 'protocol' => 'tcp', 'name' => 'Plain TCP on Port 25'],
];

foreach ($tests as $test) {
    echo "<h2>{$test['name']}</h2>";
    echo "<p>Testing {$host}:{$test['port']} ({$test['protocol']})...</p>";
    
    $errno = 0;
    $errstr = '';
    
    $connectionString = ($test['protocol'] === 'ssl') 
        ? "ssl://{$host}:{$test['port']}"
        : "{$host}:{$test['port']}";
    
    $socket = @stream_socket_client(
        $connectionString,
        $errno,
        $errstr,
        10, // shorter timeout
        STREAM_CLIENT_CONNECT,
        stream_context_create(['ssl' => ['verify_peer' => false, 'verify_peer_name' => false]])
    );
    
    if ($socket) {
        echo "<p style='color:green; font-weight:bold;'>✅ SUCCESS! Connected to {$test['name']}</p>";
        $response = fgets($socket);
        echo "<p><strong>Server Response:</strong> <code>" . htmlspecialchars($response) . "</code></p>";
        fclose($socket);
    } else {
        echo "<p style='color:red;'>❌ Failed: Error #{$errno}: " . htmlspecialchars($errstr) . "</p>";
    }
    
    echo "<hr>";
}

echo "<p><strong>Recommendation:</strong> Use the port that shows SUCCESS above.</p>";
?>

