<?php
/**
 * Simple Email Test Script
 * Run this to verify email functionality is working
 */

echo "<h1>Bait Alamer - Email System Test</h1>";
echo "<p>Testing email configuration...</p><hr>";

// Test 1: Check if mail function exists
echo "<h2>Test 1: PHP Mail Function</h2>";
if (function_exists('mail')) {
    echo "✅ mail() function is available<br>";
} else {
    echo "❌ mail() function is NOT available<br>";
    echo "Please configure PHP mail settings in php.ini<br>";
}

// Test 2: Send simple test email
echo "<h2>Test 2: Send Simple Email</h2>";
$to = 'm.oday@pazogrp.com';
$subject = 'Bait Alamer - Email Test';
$message = "This is a test email from Bait Alamer Pricing Calculator.\n\n";
$message .= "Timestamp: " . date('Y-m-d H:i:s') . "\n";
$message .= "Server: " . $_SERVER['SERVER_NAME'] . "\n";
$message .= "\nIf you receive this, the email system is working correctly.";

$headers = "From: noreply@baitalamer.com\r\n";
$headers .= "Reply-To: noreply@baitalamer.com\r\n";

$result = mail($to, $subject, $message, $headers);

if ($result) {
    echo "✅ Test email sent to $to<br>";
    echo "Please check the inbox to confirm delivery.<br>";
} else {
    echo "❌ Failed to send test email<br>";
    echo "Check PHP error logs for details.<br>";
}

// Test 3: Check file permissions
echo "<h2>Test 3: File Permissions</h2>";
$files = [
    'selling_prices.json',
    'orders.log',
    'send_order_email.php'
];

foreach ($files as $file) {
    if (file_exists($file)) {
        $perms = substr(sprintf('%o', fileperms($file)), -4);
        echo "✅ $file: Permissions $perms<br>";
        
        if (is_writable($file)) {
            echo "  - Writable: Yes<br>";
        } else {
            echo "  - ⚠️ Writable: No<br>";
        }
    } else {
        echo "❌ $file: Not found<br>";
    }
}

// Test 4: Check required PHP extensions
echo "<h2>Test 4: PHP Extensions</h2>";
$extensions = ['json', 'session'];
foreach ($extensions as $ext) {
    if (extension_loaded($ext)) {
        echo "✅ $ext extension is loaded<br>";
    } else {
        echo "❌ $ext extension is NOT loaded<br>";
    }
}

// Test 5: Test HTML email with attachment
echo "<h2>Test 5: Send HTML Email with Attachment</h2>";

$testHtml = '<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
        .container { background: white; padding: 30px; border-radius: 8px; }
        h1 { color: #2c3e50; }
        .highlight { color: #e67e22; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Test Internal Cost Summary</h1>
        <p>Order #: <span class="highlight">TEST-' . time() . '</span></p>
        <p>This is a test of the HTML attachment system.</p>
        <table border="1" cellpadding="10" style="border-collapse: collapse;">
            <tr style="background: #34495e; color: white;">
                <th>Item</th>
                <th>Selling Price</th>
                <th>Base Price</th>
            </tr>
            <tr>
                <td>Test Item</td>
                <td style="color: green;">45,000 IQD</td>
                <td style="color: orange;">37,000 IQD</td>
            </tr>
        </table>
        <p style="margin-top: 20px;">
            <strong>Total Profit:</strong> <span class="highlight">8,000 IQD</span>
        </p>
    </div>
</body>
</html>';

$boundary = md5(time());
$headers2 = "From: noreply@baitalamer.com\r\n";
$headers2 .= "Reply-To: noreply@baitalamer.com\r\n";
$headers2 .= "MIME-Version: 1.0\r\n";
$headers2 .= "Content-Type: multipart/mixed; boundary=\"{$boundary}\"\r\n";

$message2 = "--{$boundary}\r\n";
$message2 .= "Content-Type: text/plain; charset=UTF-8\r\n";
$message2 .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
$message2 .= "This is a test email with HTML attachment.\n\n";
$message2 .= "Order #: TEST-" . time() . "\n";
$message2 .= "Timestamp: " . date('Y-m-d H:i:s') . "\n\n";
$message2 .= "Please check the attached HTML file.\r\n\r\n";

// Attach HTML file
$message2 .= "--{$boundary}\r\n";
$message2 .= "Content-Type: text/html; name=\"test_internal_cost.html\"\r\n";
$message2 .= "Content-Disposition: attachment; filename=\"test_internal_cost.html\"\r\n";
$message2 .= "Content-Transfer-Encoding: base64\r\n\r\n";
$message2 .= chunk_split(base64_encode($testHtml)) . "\r\n";
$message2 .= "--{$boundary}--";

$result2 = mail($to, 'Bait Alamer - HTML Attachment Test', $message2, $headers2);

if ($result2) {
    echo "✅ HTML attachment email sent to $to<br>";
    echo "Please check inbox for HTML attachment.<br>";
} else {
    echo "❌ Failed to send HTML attachment email<br>";
}

// Summary
echo "<hr>";
echo "<h2>📊 Test Summary</h2>";
echo "<p>Email recipient: <strong>$to</strong></p>";
echo "<p>If emails were sent successfully, check the inbox within a few minutes.</p>";
echo "<p>If no emails arrive:</p>";
echo "<ul>";
echo "<li>Check spam/junk folder</li>";
echo "<li>Verify mail server configuration in php.ini</li>";
echo "<li>Check PHP error logs</li>";
echo "<li>Consider using PHPMailer for production</li>";
echo "</ul>";

// Log test
$logEntry = date('Y-m-d H:i:s') . " | EMAIL TEST | Simple: " . ($result ? 'Sent' : 'Failed') . " | HTML: " . ($result2 ? 'Sent' : 'Failed') . "\n";
file_put_contents('orders.log', $logEntry, FILE_APPEND);
echo "<p>✅ Test logged to orders.log</p>";
?>

