<?php
echo "<h1>PHP Extensions Test</h1>";
echo "<p><strong>OpenSSL Status:</strong> " . (extension_loaded('openssl') ? '✅ ENABLED' : '❌ DISABLED') . "</p>";

if (extension_loaded('openssl')) {
    echo "<p>✅ OpenSSL extension is loaded!</p>";
    echo "<h2>Testing SMTP Connection...</h2>";
    
    // Try to connect to SMTP server
    $host = 'mail.pazogrp.com';
    $port = 465;
    
    echo "<p>Attempting to connect to {$host}:{$port}...</p>";
    
    $errno = 0;
    $errstr = '';
    $socket = @stream_socket_client(
        "ssl://{$host}:{$port}",
        $errno,
        $errstr,
        30,
        STREAM_CLIENT_CONNECT,
        stream_context_create(['ssl' => ['verify_peer' => false, 'verify_peer_name' => false]])
    );
    
    if ($socket) {
        echo "<p style='color:green;'>✅ Successfully connected to {$host}:{$port}!</p>";
        $response = fgets($socket);
        echo "<p><strong>Server Response:</strong> <code>$response</code></p>";
        fclose($socket);
    } else {
        echo "<p style='color:red;'>❌ Failed to connect: Error #{$errno}: {$errstr}</p>";
    }
} else {
    echo "<p>❌ OpenSSL extension is NOT loaded. Cannot test SMTP.</p>";
}

echo "<hr>";
echo "<h2>All Loaded Extensions:</h2>";
echo "<pre>" . implode(", ", get_loaded_extensions()) . "</pre>";
?>

