<?php
/**
 * Test SMTP Connection
 * Verifies email can be sent using the configured SMTP settings
 */

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

// Load email configuration
$emailConfig = require 'email_config.php';

echo "<h1>🧪 SMTP Connection Test</h1>";
echo "<p>Testing connection to: <strong>{$emailConfig['smtp_host']}:{$emailConfig['smtp_port']}</strong></p><hr>";

$mail = new PHPMailer(true);

try {
    // Enable verbose debug output
    $mail->SMTPDebug = 2; // 0 = off, 1 = client, 2 = client and server
    $mail->Debugoutput = function($str, $level) {
        echo "<div style='background:#f0f0f0; padding:5px; margin:2px; font-family:monospace; font-size:12px;'>$str</div>";
    };
    
    // Server settings
    echo "<h2>📡 Configuring SMTP...</h2>";
    $mail->isSMTP();
    $mail->Host       = $emailConfig['smtp_host'];
    $mail->SMTPAuth   = $emailConfig['smtp_auth'];
    $mail->Username   = $emailConfig['smtp_username'];
    $mail->Password   = $emailConfig['smtp_password'];
    $mail->SMTPSecure = $emailConfig['smtp_encryption'];
    $mail->Port       = $emailConfig['smtp_port'];
    $mail->CharSet    = 'UTF-8';
    
    echo "<p>✅ SMTP Configuration Set</p>";
    echo "<ul>";
    echo "<li>Host: {$emailConfig['smtp_host']}</li>";
    echo "<li>Port: {$emailConfig['smtp_port']}</li>";
    echo "<li>Encryption: {$emailConfig['smtp_encryption']}</li>";
    echo "<li>Username: {$emailConfig['smtp_username']}</li>";
    echo "</ul>";
    
    // Recipients
    echo "<h2>📧 Setting up email...</h2>";
    $mail->setFrom($emailConfig['from_email'], $emailConfig['from_name']);
    $mail->addAddress($emailConfig['to_email'], $emailConfig['to_name']);
    
    // Content
    $mail->isHTML(false);
    $mail->Subject = 'Bait Alamer - SMTP Test';
    $mail->Body    = "This is a test email from Bait Alamer Pricing Calculator.\n\n";
    $mail->Body   .= "Timestamp: " . date('Y-m-d H:i:s') . "\n";
    $mail->Body   .= "SMTP Host: {$emailConfig['smtp_host']}\n";
    $mail->Body   .= "SMTP Port: {$emailConfig['smtp_port']}\n\n";
    $mail->Body   .= "If you receive this email, the SMTP configuration is working correctly!\n";
    
    echo "<p>✅ Email Content Prepared</p>";
    
    // Send email
    echo "<h2>📤 Sending email...</h2>";
    $mail->send();
    
    echo "<div style='background:#d4edda; padding:20px; border-radius:8px; border-left:5px solid #28a745; margin:20px 0;'>";
    echo "<h2 style='color:#155724; margin:0 0 10px 0;'>✅ SUCCESS!</h2>";
    echo "<p style='color:#155724; margin:0;'>Email has been sent successfully to <strong>{$emailConfig['to_email']}</strong></p>";
    echo "<p style='color:#155724; margin:10px 0 0 0;'>Please check the inbox to confirm delivery.</p>";
    echo "</div>";
    
} catch (Exception $e) {
    echo "<div style='background:#f8d7da; padding:20px; border-radius:8px; border-left:5px solid #dc3545; margin:20px 0;'>";
    echo "<h2 style='color:#721c24; margin:0 0 10px 0;'>❌ FAILED</h2>";
    echo "<p style='color:#721c24; margin:0;'><strong>Error:</strong> {$mail->ErrorInfo}</p>";
    echo "</div>";
    
    echo "<h3>🔍 Troubleshooting Tips:</h3>";
    echo "<ul>";
    echo "<li>Verify SMTP host is correct: {$emailConfig['smtp_host']}</li>";
    echo "<li>Verify SMTP port: {$emailConfig['smtp_port']} (465 for SSL, 587 for TLS)</li>";
    echo "<li>Verify username and password are correct</li>";
    echo "<li>Check if firewall is blocking port {$emailConfig['smtp_port']}</li>";
    echo "<li>Try changing SMTPSecure from 'ssl' to 'tls' and port to 587</li>";
    echo "</ul>";
}

echo "<hr>";
echo "<p><a href='customer.php' style='display:inline-block; padding:10px 20px; background:#3498db; color:white; text-decoration:none; border-radius:5px;'>← Back to Calculator</a></p>";
?>

