<?php
// User credentials - loaded from JSON file if exists, otherwise uses hard-coded array
// In production, passwords should be hashed with password_hash()

// Default users (fallback if JSON file doesn't exist)
$defaultUsers = [
    [
        'username' => 'manager',
        'password' => 'manager123',  // Change this password!
        'role' => 'pricing_manager'
    ],
    [
        'username' => 'sales',
        'password' => 'sales123',  // Change this password!
        'role' => 'sales_consultant'
    ],
    [
        'username' => 'admin',
        'password' => 'admin2025',  // Change this password!
        'role' => 'pricing_manager'
    ]
];

// Load users from JSON file if it exists, otherwise use default
$usersFile = __DIR__ . '/users.json';
if (file_exists($usersFile)) {
    $usersJson = file_get_contents($usersFile);
    $users = json_decode($usersJson, true);
    if (!is_array($users)) {
        $users = $defaultUsers;
    }
} else {
    $users = $defaultUsers;
}

/**
 * Authenticate user credentials
 * @param string $username
 * @param string $password
 * @return array|false Returns user array if valid, false otherwise
 */
function authenticateUser($username, $password) {
    global $users;
    
    foreach ($users as $user) {
        if ($user['username'] === $username && $user['password'] === $password) {
            return $user;
        }
    }
    
    return false;
}

/**
 * Check if user has a specific role
 * @param string $requiredRole
 * @return bool
 */
function hasRole($requiredRole) {
    return isset($_SESSION['role']) && $_SESSION['role'] === $requiredRole;
}

/**
 * Check if user is logged in
 * @return bool
 */
function isLoggedIn() {
    return isset($_SESSION['username']) && isset($_SESSION['role']);
}

/**
 * Update user password
 * @param string $username
 * @param string $newPassword
 * @return bool Returns true if successful, false otherwise
 */
function updateUserPassword($username, $newPassword) {
    global $users;
    
    $usersFile = __DIR__ . '/users.json';
    $updated = false;
    
    // Find and update the user
    foreach ($users as &$user) {
        if ($user['username'] === $username) {
            $user['password'] = $newPassword;
            $updated = true;
            break;
        }
    }
    
    if ($updated) {
        // Save to JSON file
        $jsonData = json_encode($users, JSON_PRETTY_PRINT);
        if (file_put_contents($usersFile, $jsonData) !== false) {
            return true;
        }
    }
    
    return false;
}

/**
 * Get all users (for management purposes)
 * @return array
 */
function getAllUsers() {
    global $users;
    return $users;
}
