<?php
session_start();

// Password for internal calculator access
define('INTERNAL_PASSWORD', 'bait2025');  // Change this password!

require_once __DIR__ . '/customer/pricing_functions.php';
if (isSystemLocked()) {
    header('Location: customer/maintenance.php');
    exit;
}

$error = '';
$showLogin = true;

// Check if already authenticated
if (isset($_SESSION['internal_auth']) && $_SESSION['internal_auth'] === true) {
    $showLogin = false;
}

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    if ($_POST['password'] === INTERNAL_PASSWORD) {
        $_SESSION['internal_auth'] = true;
        $showLogin = false;
    } else {
        $error = 'Incorrect password';
    }
}

// Handle logout
if (isset($_GET['logout'])) {
    unset($_SESSION['internal_auth']);
    session_destroy();
    header('Location: Alnublaa');
    exit;
}

// Load base prices from the single source of truth
require_once 'load_base_prices.php';
$basePriceMap = loadBasePrices();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bait Alamer Pricing Calculator</title>
    <link rel="stylesheet" href="styles.css">
    <link rel="stylesheet" href="print-styles.css" media="print">
    <?php if ($showLogin): ?>
    <style>
        @keyframes overlayFadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        @keyframes boxPopIn {
            from {
                opacity: 0;
                transform: scale(0.9) translateY(20px);
            }
            to {
                opacity: 1;
                transform: scale(1) translateY(0);
            }
        }
        
        .password-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.95);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 10000;
            animation: overlayFadeIn 0.4s ease-out;
        }
        
        .password-box {
            background: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.4);
            max-width: 400px;
            width: 90%;
            animation: boxPopIn 0.6s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            position: relative;
            overflow: hidden;
        }
        
        .password-box::before {
            content: '🏠';
            position: absolute;
            right: -20px;
            top: -20px;
            font-size: 120px;
            opacity: 0.05;
            pointer-events: none;
        }
        .password-box h2 {
            margin: 0 0 10px 0;
            color: #333;
        }
        .password-box p {
            color: #666;
            margin: 0 0 20px 0;
            font-size: 14px;
        }
        .password-input {
            width: 100%;
            padding: 14px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
            box-sizing: border-box;
            margin-bottom: 15px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .password-input:focus {
            outline: none;
            border-color: #e67e22;
            box-shadow: 0 0 0 3px rgba(230, 126, 34, 0.2);
            transform: translateY(-2px);
        }
        .password-btn {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #e67e22, #d35400);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 4px 15px rgba(230, 126, 34, 0.3);
            text-transform: uppercase;
            letter-spacing: 1px;
            position: relative;
            overflow: hidden;
        }
        
        .password-btn::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            transform: translate(-50%, -50%);
            transition: width 0.5s ease, height 0.5s ease;
        }
        
        .password-btn:hover::before {
            width: 400px;
            height: 400px;
        }
        
        .password-btn:hover {
            transform: translateY(-3px) scale(1.02);
            box-shadow: 0 6px 20px rgba(230, 126, 34, 0.5);
        }
        
        .password-btn:active {
            transform: translateY(-1px) scale(0.98);
        }
        .password-error {
            background: #fee;
            color: #c33;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 15px;
            text-align: center;
        }
    </style>
    <?php endif; ?>
</head>
<body>

<?php if ($showLogin): ?>
    <!-- Password Protection Overlay -->
    <div class="password-overlay">
        <div class="password-box">
            <h2>🔒 Internal Access Only</h2>
            <p>This calculator is for internal company use. Please enter the password to continue.</p>
            
            <?php if ($error): ?>
                <div class="password-error"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <input type="password" name="password" class="password-input" placeholder="Enter password" autofocus required>
                <button type="submit" class="password-btn">Access Calculator</button>
            </form>
        </div>
    </div>
<?php else: ?>
    <!-- Main Calculator (from original index.html) -->
    <div class="container">
        <!-- Top Navigation for internal users -->
        <div class="no-print" style="position: fixed; top: 20px; right: 20px; z-index: 1000; display: flex; gap: 10px;">
            <a href="announcements.php" style="background: #3498db; color: white; padding: 8px 16px; border-radius: 5px; text-decoration: none; font-weight: 600; font-size: 14px;">
                📢 Manage Announcements
            </a>
            <a href="?logout=1" style="background: #c0392b; color: white; padding: 8px 16px; border-radius: 5px; text-decoration: none; font-weight: 600; font-size: 14px;">
                🔓 Logout
            </a>
        </div>

        <!-- Header -->
        <header class="page-header">
            <div class="language-toggle">
                <button id="langToggle" onclick="toggleLanguage()">
                    <span id="langText">العربية</span>
                </button>
            </div>
            <div class="header-content">
                <div class="header-logo">
                    <img src="logo.png" alt="Bait Alamer Logo">
                </div>
                <div class="header-text">
                    <h1 data-en="Bait Alamer Pricing Calculator" data-ar="حاسبة التسعير - بيت العامر">Bait Alamer Pricing Calculator</h1>
                    <p class="subtitle" data-en="Professional Quality Assurance Pricing Tool" data-ar="أداة تسعير احترافية لضمان الجودة">Professional Quality Assurance Pricing Tool</p>
                </div>
            </div>
        </header>

        <!-- Section A: Header Fields -->
        <section class="header-fields">
            <h2 data-en="Site Information" data-ar="معلومات الموقع">Site Information</h2>
            <div class="field-grid">
                <div class="field-group">
                    <label for="customerName">
                        <span class="required">*</span> <span data-en="Customer Name" data-ar="اسم العميل">Customer Name</span>
                    </label>
                    <input type="text" id="customerName" data-placeholder-en="Enter customer name" data-placeholder-ar="أدخل اسم العميل" placeholder="Enter customer name">
                    <span class="error-message" id="error-customerName"></span>
                </div>

                <div class="field-group">
                    <label for="siteLocation">
                        <span class="required">*</span> <span data-en="Site Location" data-ar="موقع المشروع">Site Location</span>
                    </label>
                    <input type="text" id="siteLocation" data-placeholder-en="Enter site location" data-placeholder-ar="أدخل موقع المشروع" placeholder="Enter site location">
                    <span class="error-message" id="error-siteLocation"></span>
                </div>

                <div class="field-group">
                    <label for="numRooms">
                        <span class="conditional-required" id="rooms-asterisk">*</span> <span data-en="Number of Rooms" data-ar="عدد الغرف">Number of Rooms</span>
                    </label>
                    <input type="number" id="numRooms" placeholder="0" min="0" step="1">
                    <span class="help-text" data-en="Required if electricity or paint items selected" data-ar="مطلوب عند اختيار عناصر الكهرباء أو الطلاء">Required if electricity or paint items selected</span>
                    <span class="error-message" id="error-numRooms"></span>
                </div>

                <div class="field-group">
                    <label for="avgRoomArea">
                        <span class="conditional-required" id="area-asterisk">*</span> <span data-en="Average Room Area (m²)" data-ar="متوسط مساحة الغرفة (م²)">Average Room Area (m²)</span>
                    </label>
                    <input type="number" id="avgRoomArea" placeholder="0" min="0" step="0.1">
                    <span class="help-text" data-en="Required only if electricity item selected" data-ar="مطلوب فقط عند اختيار عنصر الكهرباء">Required only if electricity item selected</span>
                    <span class="error-message" id="error-avgRoomArea"></span>
                </div>

                <div class="field-group">
                    <label for="paintColorCode">
                        <span class="conditional-required" id="paint-asterisk">*</span> <span data-en="Paint Color Code" data-ar="كود لون الطلاء">Paint Color Code</span>
                    </label>
                    <input type="text" id="paintColorCode" data-placeholder-en="e.g. RAL 9010" data-placeholder-ar="مثال: RAL 9010" placeholder="e.g. RAL 9010">
                    <span class="help-text" data-en="Required only if paint items selected" data-ar="مطلوب فقط عند اختيار عناصر الطلاء">Required only if paint items selected</span>
                    <span class="error-message" id="error-paintColorCode"></span>
                </div>

                <div class="field-group full-width">
                    <label for="generalNotes"><span data-en="General Notes" data-ar="ملاحظات عامة">General Notes</span></label>
                    <textarea id="generalNotes" rows="2" data-placeholder-en="Any additional notes (optional)" data-placeholder-ar="أي ملاحظات إضافية (اختياري)" placeholder="Any additional notes (optional)"></textarea>
                </div>
            </div>
        </section>

        <!-- Section B: Items Table -->
        <section class="items-section">
            <h2 data-en="Select Items & Enter Quantities" data-ar="اختر العناصر وأدخل الكميات">Select Items & Enter Quantities</h2>
            
            <div id="categoriesContainer">
                <!-- Categories will be generated by JavaScript -->
            </div>
        </section>

        <!-- Section C: Summary -->
        <section class="summary-section">
            <h2 data-en="Summary" data-ar="الملخص">Summary</h2>
            
            <div class="category-totals" id="categoryTotals">
                <!-- Category subtotals will be generated here -->
            </div>

            <div class="grand-total">
                <span class="total-label" data-en="GRAND TOTAL:" data-ar="المجموع الإجمالي:">GRAND TOTAL:</span>
                <span class="total-amount" id="grandTotal">0 IQD</span>
            </div>

            <div class="action-buttons">
                <button id="calculateBtn" class="btn btn-primary">
                    <span data-en="📊 Calculate Total" data-ar="📊 احسب المجموع">📊 Calculate Total</span>
                </button>
                <button id="clearBtn" class="btn btn-secondary">
                    <span data-en="🗑️ Clear All" data-ar="🗑️ مسح الكل">🗑️ Clear All</span>
                </button>
                <button id="printBtn" class="btn btn-secondary">
                    <span data-en="🖨️ Print / Export PDF" data-ar="🖨️ طباعة / تصدير PDF">🖨️ Print / Export PDF</span>
                </button>
            </div>

            <div id="validationSummary" class="validation-summary hidden">
                <h3 data-en="⚠️ Please fix the following:" data-ar="⚠️ يرجى إصلاح التالي:">⚠️ Please fix the following:</h3>
                <ul id="validationList"></ul>
            </div>
        </section>

        <footer class="page-footer">
            <p data-en="© 2025 Bait Alamer | Pricing Calculator v1.0" data-ar="© 2025 بيت العامر | حاسبة التسعير الإصدار 1.0">© 2025 Bait Alamer | Pricing Calculator v1.0</p>
        </footer>
    </div>

    <script>
        // Inject base prices from PHP (single source of truth)
        const BASE_PRICE_MAP = <?php echo json_encode($basePriceMap); ?>;
    </script>
    <script src="calculator.js"></script>
<?php endif; ?>

</body>
</html>

