<?php
/**
 * Load base prices from the single source of truth
 * This file is used by both index.php and customer.php to ensure consistency
 */

function loadBasePrices() {
    $basePricesFile = __DIR__ . '/base_prices.json';
    
    if (!file_exists($basePricesFile)) {
        return [];
    }
    
    $json = file_get_contents($basePricesFile);
    $prices = json_decode($json, true);
    
    if (!is_array($prices)) {
        return [];
    }
    
    // Create a lookup map: id => base_price
    $priceMap = [];
    foreach ($prices as $item) {
        if (isset($item['id']) && isset($item['base_price'])) {
            $priceMap[$item['id']] = $item['base_price'];
        }
    }
    
    return $priceMap;
}
?>

